/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.cleaners;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pekar.angelblock.events.cleaners.TrackedAllay;
import com.pekar.angelblock.events.cleaners.TrackedAllayData;
import com.pekar.angelblock.events.cleaners.TrackedAllayDataCodec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class TrackedAllaysData
extends SavedData {
    private final HashSet<TrackedAllayData> saved;
    public static final Codec<TrackedAllaysData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(TrackedAllayDataCodec.CODEC).xmap(HashSet::new, ArrayList::new).fieldOf("Tracked").forGetter(data -> data.saved)).apply((Applicative)instance, TrackedAllaysData::new));
    public static final SavedDataType<TrackedAllaysData> TYPE = new SavedDataType("tracked_allays", ctx -> new TrackedAllaysData(), ctx -> CODEC);

    public TrackedAllaysData(HashSet<TrackedAllayData> saved) {
        this.saved = saved;
    }

    public TrackedAllaysData() {
        this.saved = new HashSet();
    }

    public void store(TrackedAllay allay) {
        this.saved.add(new TrackedAllayData(((Allay)allay.getTargetInstance()).getUUID(), allay.getOwner().getUUID()));
        this.setDirty();
    }

    public void remove(TrackedAllay allay) {
        TrackedAllayData allayData = new TrackedAllayData(((Allay)allay.getTargetInstance()).getUUID(), allay.getOwner().getUUID());
        this.remove(allayData);
    }

    private void remove(TrackedAllayData data) {
        if (!this.saved.contains(data)) {
            return;
        }
        this.saved.remove(data);
        this.setDirty();
    }

    public Set<TrackedAllayData> getSaved() {
        return this.saved;
    }

    public static TrackedAllaysData get(ServerLevel level) {
        return (TrackedAllaysData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    public static Set<TrackedAllay> restoreAllays(ServerPlayer player, TrackedAllaysData data) {
        HashSet<TrackedAllay> result = new HashSet<TrackedAllay>();
        ServerLevel level = (ServerLevel)player.level();
        for (TrackedAllayData dto : data.getSaved()) {
            Player owner;
            if (!player.getUUID().equals(dto.ownerUuid()) || (owner = level.getPlayerByUUID(dto.ownerUuid())) == null) continue;
            Entity entity = level.getEntity(dto.allayUuid());
            if (!(entity instanceof Allay)) {
                TrackedAllaysData.get(level).remove(dto);
                continue;
            }
            Allay allay = (Allay)entity;
            TrackedAllay tracked = new TrackedAllay(allay, owner);
            result.add(tracked);
        }
        return result;
    }
}

