/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.utils;

import com.pekar.angelblock.network.packets.PlaySoundPacket;
import com.pekar.angelblock.utils.SoundType;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Sound {
    public void playSoundByBlock(Player player, BlockPos pos, SoundEvent soundEvent, float volume, float pitch) {
        this.playSound(player, pos, soundEvent, SoundSource.BLOCKS, volume, pitch);
    }

    public void playSoundByBlock(Player player, BlockPos pos, SoundEvent soundEvent) {
        this.playSoundByBlock(player, pos, soundEvent, 1.0f, 1.0f);
    }

    public void playSoundByBlock(Player player, BlockPos pos, SoundType soundType) {
        SoundEvent soundEvent = this.getSound(soundType);
        if (soundEvent == null) {
            return;
        }
        this.playSoundByBlock(player, pos, soundEvent, 1.0f, 5.0f);
    }

    public void playSoundOnBothSides(ServerPlayer player, BlockPos pos, SoundType soundType, SoundSource soundSource, float pitch) {
        SoundEvent soundEvent = this.getSound(soundType);
        if (soundEvent == null) {
            return;
        }
        Level level = player.level();
        new PlaySoundPacket(soundEvent, pitch).sendToPlayer(player);
        level.playSound((Entity)player, pos, soundEvent, soundSource, 1.0f, pitch);
    }

    public void playSoundByLivingEntity(Player player, LivingEntity sourceEntity, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch) {
        Level level = player.level();
        if (level.isClientSide()) {
            level.playLocalSound(sourceEntity.blockPosition(), soundEvent, soundSource, volume, pitch, true);
        } else {
            level.playSound((Entity)player, (Entity)sourceEntity, soundEvent, soundSource, volume, pitch);
        }
    }

    public void playSound(Player player, BlockPos pos, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch) {
        Level level = player.level();
        if (level.isClientSide()) {
            level.playLocalSound(pos, soundEvent, soundSource, volume, pitch, true);
        } else {
            level.playSound((Entity)player, pos, soundEvent, soundSource, volume, pitch);
        }
    }

    private SoundEvent getSound(SoundType soundType) {
        return switch (soundType) {
            case SoundType.PLANT -> SoundEvents.CROP_PLANTED;
            case SoundType.BLOCK_CHANGED -> SoundEvents.STONE_BREAK;
            case SoundType.WATER_PLACED -> SoundEvents.PLAYER_SPLASH_HIGH_SPEED;
            case SoundType.LAVA_PLACED -> SoundEvents.LAVA_POP;
            case SoundType.STEAM -> SoundEvents.LAVA_EXTINGUISH;
            case SoundType.AMETHYST_FOUND -> (SoundEvent)SoundEvents.NOTE_BLOCK_XYLOPHONE.value();
            case SoundType.DIAMOND_FOUND -> (SoundEvent)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE.value();
            case SoundType.ORE_FOUND -> SoundEvents.GRAVEL_PLACE;
            case SoundType.SCULK_FOUND -> SoundEvents.SCULK_CLICKING;
            case SoundType.INFESTED_BLOCK -> SoundEvents.SILVERFISH_DEATH;
            case SoundType.BONEMEAL -> SoundEvents.BONE_MEAL_USE;
            case SoundType.RAIL_PLACED -> SoundEvents.METAL_PLACE;
            case SoundType.REDSTONE_WIRE_PLACED, SoundType.STONE_PLACED -> SoundEvents.STONE_PLACE;
            case SoundType.WOOD_PLACED -> SoundEvents.WOOD_PLACE;
            case SoundType.RAILS_FOUND -> SoundEvents.ANVIL_LAND;
            default -> null;
        };
    }
}

