/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.blocks.tile_entities;

import com.pekar.angelblock.blocks.tile_entities.DespawnMonsterBlockEntity;
import com.pekar.angelblock.blocks.tile_entities.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class AngelRodBlockEntity
extends DespawnMonsterBlockEntity<AngelRodBlockEntity> {
    private static final String DamageTagName = "angelblock:AngelRodDamage";
    private int damage;

    public AngelRodBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EntityRegistry.ANGEL_ROD_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    @Override
    protected double getEffectiveRadius() {
        return 20.0;
    }

    @Override
    protected boolean needToDespawnEntity(Entity entity) {
        return entity instanceof Enemy;
    }

    @Override
    protected void loadModTag(ValueInput input) {
        this.damage = input.getIntOr(DamageTagName, 0);
    }

    @Override
    protected void saveModTag(ValueOutput output) {
        output.putInt(DamageTagName, this.damage);
    }

    @Override
    protected void saveModTag(CompoundTag tag) {
        tag.putInt(DamageTagName, this.damage);
    }

    public void setDamage(int damage) {
        this.damage = damage;
        CompoundTag tag = new CompoundTag();
        this.saveModTag(tag);
    }

    public int getDamage() {
        return this.damage;
    }
}

