/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.armor;

import com.pekar.angelblock.armor.ArmorRegistry;
import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.events.armor.Armor;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.effect.GlowingSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.HealthBoostPermanentArmorEffect;
import com.pekar.angelblock.events.effect.IPermanentArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingEffectSynchronizer;
import com.pekar.angelblock.events.effect.ITemporaryArmorEffect;
import com.pekar.angelblock.events.effect.ITemporaryPersistentArmorEffect;
import com.pekar.angelblock.events.effect.JumpBoostSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.JumpNegativeArmorEffect;
import com.pekar.angelblock.events.effect.LuckPermanentArmorEffect;
import com.pekar.angelblock.events.effect.NightVisionSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.RegenerationTemporaryArmorEffect;
import com.pekar.angelblock.events.effect.SlowFallingSwitchingEffect;
import com.pekar.angelblock.events.effect.SpeedSwitchingEffect;
import com.pekar.angelblock.events.effect.SwitchingEffectSynchronizer;
import com.pekar.angelblock.events.effect.WaterBreathingTemporaryEffect;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.keybinds.KeyRegistry;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class LimoniteArmor
extends Armor {
    private final IPermanentArmorEffect luckEffect;
    private final IPermanentArmorEffect healthBoostEffect;
    private final ITemporaryArmorEffect regenerationEffect;
    private final ITemporaryArmorEffect waterBreathingEffect;
    private final ITemporaryPersistentArmorEffect jumpNegativeEffect;
    private final ISwitchingArmorEffect nightVisionEffect;
    private final ISwitchingArmorEffect glowingEffect;
    private final ISwitchingEffectSynchronizer jumpEffect;
    private boolean hasWaterBreathingBeenUsed;
    private static final int HEAL_REGENERATION_EFFECT_DURATION = 300;
    private static final int MONSTER_SLOWDOWNED_EFFECT_DURATION = 100;
    private static final int REGENERATION_NEGATIVE_EFFECT_DURATION = 1200;
    private static final int ATTACKING_MONSTER_GLOWING_EFFECT_DURATION = 400;
    private static final int JUMP_EFFECT_AMPLIFIER_DEFAULT = 2;
    private static final int JUMP_EFFECT_AMPLIFIER_BOOSTED = 6;
    private static final int WATER_BREATHING_EFFECT_DURATION = 600;

    public LimoniteArmor(IPlayer player) {
        super(player);
        this.nightVisionEffect = (ISwitchingArmorEffect)new NightVisionSwitchingArmorEffect(player, this).availableOnHelmetWithDetector();
        this.glowingEffect = (ISwitchingArmorEffect)new GlowingSwitchingArmorEffect(player, this).availableIfSlotSet(EquipmentSlot.CHEST);
        this.luckEffect = (IPermanentArmorEffect)new LuckPermanentArmorEffect(player, this).setupAvailability(this::isLuckEffectAvailable);
        this.healthBoostEffect = new HealthBoostPermanentArmorEffect(player, this, 1);
        this.regenerationEffect = new RegenerationTemporaryArmorEffect(player, (IArmor)this, 0, 300);
        this.jumpNegativeEffect = new JumpNegativeArmorEffect(player, (IArmor)this, 1, 1200);
        this.waterBreathingEffect = new WaterBreathingTemporaryEffect(player, (IArmor)this, 0, 600);
        JumpBoostSwitchingArmorEffect jumpEffect = new JumpBoostSwitchingArmorEffect(player, this, 2);
        jumpEffect.availableIfSlotSet(EquipmentSlot.FEET);
        SpeedSwitchingEffect speedEffect = new SpeedSwitchingEffect(player, this, 0);
        SlowFallingSwitchingEffect slowFallingEffect = new SlowFallingSwitchingEffect(player, this);
        slowFallingEffect.availableIfSlotSet(EquipmentSlot.CHEST);
        this.jumpEffect = new SwitchingEffectSynchronizer(jumpEffect);
        this.jumpEffect.addDependentEffect(speedEffect);
        this.jumpEffect.addDependentEffect(slowFallingEffect);
    }

    @Override
    protected void updateAvailability() {
        this.jumpNegativeEffect.updateAvailability();
        this.nightVisionEffect.updateAvailability();
        this.waterBreathingEffect.updateAvailability();
        this.luckEffect.updateAvailability();
        this.glowingEffect.updateAvailability();
        this.healthBoostEffect.updateAvailability();
        this.regenerationEffect.updateAvailability();
        this.jumpEffect.updateAvailability();
    }

    @Override
    protected void updateEffectStates() {
        this.nightVisionEffect.updateSwitchState();
        this.glowingEffect.updateSwitchState();
        this.waterBreathingEffect.updateSwitchState();
        if (!this.jumpNegativeEffect.isAnyActive()) {
            this.jumpEffect.updateSwitchState();
        }
    }

    @Override
    protected void updateActivity(EquipmentSlot slot) {
        this.jumpNegativeEffect.updateActivity();
    }

    @Override
    public void updateActivityForFeetSlot() {
        if (!this.jumpNegativeEffect.isActive()) {
            this.jumpEffect.updateActivity(this.getJumpEffectAmplifier());
        } else {
            this.jumpEffect.updateDependentEffectsActivity();
        }
    }

    @Override
    public void updateActivityForLegsSlot() {
        this.healthBoostEffect.updateActivity();
        this.regenerationEffect.updateActivity();
    }

    @Override
    public void updateActivityForChestSlot() {
        this.luckEffect.updateActivity();
        this.glowingEffect.updateActivity();
    }

    @Override
    public void updateActivityForHeadSlot() {
        this.nightVisionEffect.updateActivity();
        this.waterBreathingEffect.updateActivity();
    }

    @Override
    protected void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        Player entityPlayer = this.player.getEntity();
        if (this.playerNeedsToRestoreHealth(entityPlayer, event.getSlot(), event.getFrom(), event.getTo())) {
            this.restorePlayerHealth(entityPlayer);
        }
    }

    @Override
    public void onLivingHurtEvent(LivingIncomingDamageEvent event) {
        DamageSource damageSource = event.getSource();
        boolean isAnyArmorElementPutOn = this.player.isAnyArmorElementPutOn(this);
        if (this.isFreezeDamage(damageSource)) {
            event.setCanceled(isAnyArmorElementPutOn);
        } else if (this.isThornOrMagicDamage(damageSource)) {
            event.setCanceled(this.player.areLeggingsModifiedWithHealthRegenerator(this));
        } else if (this.player.isEffectActive((Holder<MobEffect>)MobEffects.POISON) && this.player.areLeggingsModifiedWithHealthRegenerator(this)) {
            this.player.clearEffect((Holder<MobEffect>)MobEffects.POISON);
            event.setCanceled(damageSource.getMsgId().equals("magic"));
        }
        boolean isFullArmorSet = this.player.isFullArmorSetPutOn(this);
        if (!isFullArmorSet) {
            return;
        }
        Entity entity = damageSource.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entityAttackedBy = (LivingEntity)entity;
        if (this.isSlowMovementAffected(entityAttackedBy)) {
            boolean isWitch = entityAttackedBy instanceof Witch;
            float distance = this.player.getEntity().distanceTo((Entity)entityAttackedBy);
            if (!isWitch && distance > 2.0f) {
                entityAttackedBy.setRemainingFireTicks(100);
            } else {
                entityAttackedBy.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 100, 2));
            }
        }
        MobEffectInstance effect = new MobEffectInstance(MobEffects.GLOWING, 400, 0, false, false, false);
        entityAttackedBy.addEffect(effect);
    }

    @Override
    public void onLivingDamageEvent(LivingDamageEvent.Pre event) {
        DamageSource damageSource = event.getSource();
        Entity attacker = damageSource.getEntity();
        if (this.isBiting(attacker)) {
            if (this.player.isFullArmorSetPutOn(this)) {
                float damageAmount = event.getNewDamage();
                event.setNewDamage(damageAmount * 0.2f);
            }
        } else if (this.isVulnerable(damageSource)) {
            event.setNewDamage(event.getNewDamage() * 1.5f);
        }
    }

    @Override
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
    }

    @Override
    public void onLivingFallEvent(LivingFallEvent event) {
    }

    @Override
    public void onCreeperCheck() {
        Player playerEntity = this.player.getEntity();
        if (!playerEntity.isUnderWater()) {
            this.hasWaterBreathingBeenUsed = false;
            if (this.waterBreathingEffect.isAvailable() && this.waterBreathingEffect.isActive()) {
                this.waterBreathingEffect.tryRemove();
            }
        }
        boolean isHelmetModifiedWithDetector = this.player.isHelmetModifiedWithDetector(this);
        this.detectCreepers(isHelmetModifiedWithDetector, this.player.isFullArmorSetPutOn(this));
    }

    @Override
    public void onEffectAddedEvent(MobEffectEvent.Added event) {
    }

    @Override
    public void onKeyInputEvent(String pressedKeyDescription) {
        if (pressedKeyDescription.equals(KeyRegistry.REGENERATION.getName()) && this.regenerationEffect.isAvailable() && !this.regenerationEffect.isAnyActive() && this.player.getEntity().getHealth() < this.player.getEntity().getMaxHealth()) {
            this.jumpEffect.trySwitchOff();
            this.jumpNegativeEffect.tryActivate();
            this.regenerationEffect.tryActivate();
        }
        if (pressedKeyDescription.equals(KeyRegistry.NIGHT_VISION.getName())) {
            this.nightVisionEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.GLOWING.getName())) {
            this.glowingEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.JUMP_BOOST.getName()) && !this.jumpNegativeEffect.isAnyActive()) {
            this.jumpEffect.trySwitch(this.getJumpEffectAmplifier());
        }
    }

    @Override
    public void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
    }

    @Override
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
    }

    @Override
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (this.jumpEffect.isOn()) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.2f);
        }
    }

    @Override
    public void onBeingInLava() {
    }

    @Override
    public void onBeingInWater() {
        if (!this.hasWaterBreathingBeenUsed && !this.waterBreathingEffect.isAnyActive() && this.player.getEntity().isUnderWater()) {
            this.hasWaterBreathingBeenUsed = true;
            this.waterBreathingEffect.tryActivate();
        }
    }

    @Override
    public void onBeingUnderRain() {
        if (!this.player.isFullArmorSetPutOn(this)) {
            return;
        }
        Player entityPlayer = this.player.getEntity();
        if (entityPlayer.getHealth() < entityPlayer.getMaxHealth()) {
            this.regenerationEffect.tryActivate(100);
            entityPlayer.causeFoodExhaustion(0.5f);
        }
    }

    @Override
    public String getFamilyName() {
        return ((ModArmor)ArmorRegistry.LIMONITE_BOOTS.get()).getArmorFamilyName();
    }

    @Override
    public int getPriority() {
        return 4;
    }

    private int getJumpEffectAmplifier() {
        return this.player.areBootsModifiedWithJumpBooster(this) ? 6 : 2;
    }

    private boolean isLuckEffectAvailable(IPlayer player, IArmor armor) {
        return player.isChestPlateModifiedWithLuck(armor);
    }
}

