/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.armor;

import com.pekar.angelblock.armor.ArmorRegistry;
import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.events.armor.Armor;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.effect.GlowingSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingEffectSynchronizer;
import com.pekar.angelblock.events.effect.ITemporaryPersistentArmorEffect;
import com.pekar.angelblock.events.effect.JumpBoostSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.JumpNegativeArmorEffect;
import com.pekar.angelblock.events.effect.NauseaNegativeEffect;
import com.pekar.angelblock.events.effect.NightVisionSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.SlowFallingSwitchingEffect;
import com.pekar.angelblock.events.effect.SpeedSwitchingEffect;
import com.pekar.angelblock.events.effect.SwitchingEffectSynchronizer;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.keybinds.KeyRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class RendelithicArmor
extends Armor {
    private final ITemporaryPersistentArmorEffect nauseaEffect;
    private final ITemporaryPersistentArmorEffect jumpNegativeEffect;
    private final ISwitchingArmorEffect slowFallingEffect;
    private final ISwitchingArmorEffect glowingEffect;
    private final ISwitchingEffectSynchronizer jumpEffect;
    private final ISwitchingArmorEffect nightVisionEffect;
    private static final int JUMP_EFFECT_AMPLIFIER_DEFAULT = 3;
    private static final int JUMP_EFFECT_AMPLIFIER_BOOSTED = 5;
    private static final int SLOWNESS_NEGATIVE_EFFECT_AMPLIFIER = 5;
    private static final int SLOWNESS_NEGATIVE_EFFECT_DURATION = 400;
    private static final int NAUSEA_NEGATIVE_EFFECT_DURATION = 200;

    public RendelithicArmor(IPlayer player) {
        super(player);
        this.nightVisionEffect = (ISwitchingArmorEffect)new NightVisionSwitchingArmorEffect(player, this).availableOnHelmetWithNightVision();
        this.nauseaEffect = (ITemporaryPersistentArmorEffect)new NauseaNegativeEffect(player, this, 200).showIcon();
        this.jumpNegativeEffect = new JumpNegativeArmorEffect(player, (IArmor)this, 5, 400);
        this.slowFallingEffect = (ISwitchingArmorEffect)new SlowFallingSwitchingEffect(player, this).availableOnChestPlateWithSlowFalling();
        this.glowingEffect = (ISwitchingArmorEffect)new GlowingSwitchingArmorEffect(player, this).availableOnChestPlateWithSlowFalling();
        JumpBoostSwitchingArmorEffect jumpEffect = new JumpBoostSwitchingArmorEffect(player, this, 3);
        jumpEffect.availableIfSlotSet(EquipmentSlot.FEET);
        SpeedSwitchingEffect speedEffect = new SpeedSwitchingEffect(player, this, 0);
        this.jumpEffect = new SwitchingEffectSynchronizer(jumpEffect);
        this.jumpEffect.addDependentEffect(speedEffect);
    }

    @Override
    protected void updateAvailability() {
        this.nightVisionEffect.updateAvailability();
        this.jumpEffect.updateAvailability();
        this.nauseaEffect.updateAvailability();
        this.jumpNegativeEffect.updateAvailability();
        this.slowFallingEffect.updateAvailability();
        this.glowingEffect.updateAvailability();
    }

    @Override
    protected void updateEffectStates() {
        this.nightVisionEffect.updateSwitchState();
        this.jumpEffect.updateSwitchState();
        this.slowFallingEffect.updateSwitchState();
        this.glowingEffect.updateSwitchState();
    }

    @Override
    protected void updateActivityForHeadSlot() {
        this.nightVisionEffect.updateActivity();
    }

    @Override
    protected void updateActivityForFeetSlot() {
    }

    @Override
    protected void updateActivityForLegsSlot() {
    }

    @Override
    protected void updateActivityForChestSlot() {
        this.glowingEffect.updateActivity();
        if (!this.jumpNegativeEffect.isAnyActive()) {
            this.slowFallingEffect.updateActivity();
        }
    }

    @Override
    protected void updateActivity(EquipmentSlot slot) {
        this.jumpEffect.updateActivity(this.getJumpBoostAmplifier());
        this.checkForNausea();
    }

    @Override
    public void onLivingHurtEvent(LivingIncomingDamageEvent event) {
        boolean hasHealthRegeneration;
        DamageSource damageSource = event.getSource();
        if (this.isFireDamage(damageSource)) {
            if (!this.isStandingInSoulFire()) {
                float realDamage = this.getRealDamage(event.getAmount());
                event.setCanceled(realDamage <= 0.0f);
            }
            if (this.player.isFullArmorSetPutOn(this)) {
                event.getEntity().clearFire();
            }
        } else if (this.isLavaDamage(damageSource)) {
            event.setCanceled(this.player.isFullArmorSetPutOn(this));
        } else if (damageSource.is(DamageTypes.WITHER) && (hasHealthRegeneration = this.player.areLeggingsModifiedWithHealthRegenerator(this))) {
            event.setCanceled(true);
            this.player.getEntity().removeEffect(MobEffects.WITHER);
        }
    }

    @Override
    public void onLivingDamageEvent(LivingDamageEvent.Pre event) {
        DamageSource damageSource = event.getSource();
        if (this.isFireDamage(damageSource) && !this.isStandingInSoulFire()) {
            float realDamage = this.getRealDamage(event.getNewDamage());
            event.setNewDamage(realDamage);
        }
    }

    @Override
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
    }

    @Override
    public void onLivingFallEvent(LivingFallEvent event) {
    }

    @Override
    public void onCreeperCheck() {
        Player player = this.player.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.breakBlockUnderPlayer(serverPlayer, true, this.isIcePredicate, Blocks.WATER.defaultBlockState(), this.playIceBreakSound, 32);
        }
    }

    @Override
    public void onEffectAddedEvent(MobEffectEvent.Added event) {
    }

    @Override
    public void onKeyInputEvent(String pressedKeyDescription) {
        if (pressedKeyDescription.equals(KeyRegistry.NIGHT_VISION.getName())) {
            this.nightVisionEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.JUMP_BOOST.getName())) {
            this.jumpEffect.trySwitch(this.getJumpBoostAmplifier());
        }
        if (pressedKeyDescription.equals(KeyRegistry.LEVITATION.getName()) && this.slowFallingEffect.isAvailable() && (!this.jumpNegativeEffect.isAnyActive() || this.slowFallingEffect.isOn())) {
            this.slowFallingEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.GLOWING.getName())) {
            this.glowingEffect.trySwitch();
        }
    }

    @Override
    public void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
    }

    @Override
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
    }

    @Override
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (this.player.getEntity().isInWater()) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.02f);
        } else if (this.jumpEffect.isOn()) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.2f);
        }
    }

    @Override
    public void onBeingInLava() {
    }

    @Override
    public void onBeingInWater() {
        this.checkForNausea();
    }

    @Override
    public void onBeingUnderRain() {
        this.checkForNausea();
    }

    @Override
    public String getFamilyName() {
        return ((ModArmor)ArmorRegistry.RENDELITHIC_BOOTS.get()).getArmorFamilyName();
    }

    @Override
    public int getPriority() {
        return 2;
    }

    private int getJumpBoostAmplifier() {
        return this.player.areBootsModifiedWithJumpBooster(this) ? 5 : 3;
    }

    private void checkForNausea() {
        Player entity = this.player.getEntity();
        if (entity.isInWaterOrRain() && !this.jumpNegativeEffect.isActive()) {
            this.nauseaEffect.tryActivate();
            this.jumpNegativeEffect.tryActivate();
            if (this.slowFallingEffect.isOn()) {
                this.slowFallingEffect.trySwitchOff();
            }
        }
    }

    private float getRealDamage(float initialDamageAmount) {
        float helmetProtection = this.player.isArmorElementPutOn(this, EquipmentSlot.HEAD) ? initialDamageAmount * 0.2f : 0.0f;
        float bootsProtection = this.player.isArmorElementPutOn(this, EquipmentSlot.FEET) ? initialDamageAmount * 0.2f : 0.0f;
        float chestplateProtection = this.player.isArmorElementPutOn(this, EquipmentSlot.CHEST) ? initialDamageAmount * 0.35f : 0.0f;
        float leggingsProtection = this.player.isArmorElementPutOn(this, EquipmentSlot.LEGS) ? initialDamageAmount * 0.3f : 0.0f;
        float realDamage = initialDamageAmount - helmetProtection - bootsProtection - chestplateProtection - leggingsProtection;
        return realDamage > 0.0f ? realDamage : 0.0f;
    }
}

