/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.effect;

import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.effect.IArmorEffect;
import com.pekar.angelblock.events.effect.IEffectSetup;
import com.pekar.angelblock.events.player.IPlayer;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

interface EffectSetup<T extends IArmorEffect>
extends IEffectSetup<T> {
    public void setShowIcon(boolean var1);

    public void setAvailabilityPredicate(BiPredicate<IPlayer, IArmor> var1);

    public BiPredicate<IPlayer, IArmor> getAvailabilityPredicate();

    public void setUnavailabilityPredicate(BiPredicate<IPlayer, IArmor> var1);

    public BiPredicate<IPlayer, IArmor> getUnavailabilityPredicate();

    public T getSelf();

    @Override
    default public T alwaysAvailable() {
        this.setAvailabilityPredicate((player, armor) -> true);
        return this.getSelf();
    }

    @Override
    default public T setupAvailability(IEffectSetup<T> copyFrom) {
        this.setAvailabilityPredicate(((EffectSetup)copyFrom).getAvailabilityPredicate());
        return this.getSelf();
    }

    @Override
    default public T setupUnavailability(IEffectSetup<T> copyFrom) {
        this.setUnavailabilityPredicate(((EffectSetup)copyFrom).getUnavailabilityPredicate());
        return this.getSelf();
    }

    @Override
    default public T setupAvailability(BiPredicate<IPlayer, IArmor> predicate) {
        this.setAvailabilityPredicate(predicate);
        return this.getSelf();
    }

    @Override
    default public T setupUnavailability(BiPredicate<IPlayer, IArmor> predicate) {
        this.setUnavailabilityPredicate(predicate);
        return this.getSelf();
    }

    @Override
    default public T availableOnHelmetWithDetector() {
        this.setAvailabilityPredicate(IPlayer::isHelmetModifiedWithDetector);
        return this.getSelf();
    }

    @Override
    default public T availableOnHelmetWithNightVision() {
        this.setAvailabilityPredicate(IPlayer::isHelmetModifiedWithNightVision);
        return this.getSelf();
    }

    @Override
    default public T availableOnBootsWithJumpBooster() {
        this.setAvailabilityPredicate(IPlayer::areBootsModifiedWithJumpBooster);
        return this.getSelf();
    }

    @Override
    default public T availableOnBootsWithSeaPower() {
        this.setAvailabilityPredicate(IPlayer::areBootsModifiedWithSeaPower);
        return this.getSelf();
    }

    @Override
    default public T availableOnChestPlateWithStrengthBooster() {
        this.setAvailabilityPredicate(IPlayer::isChestPlateModifiedWithStrengthBooster);
        return this.getSelf();
    }

    @Override
    default public T availableOnChestPlateWithSlowFalling() {
        this.setAvailabilityPredicate(IPlayer::isChestPlateModifiedWithSlowFalling);
        return this.getSelf();
    }

    @Override
    default public T availableOnLeggingsWithHealthRegenerator() {
        this.setAvailabilityPredicate(IPlayer::areLeggingsModifiedWithHealthRegenerator);
        return this.getSelf();
    }

    @Override
    default public T availableOnFullArmorSet() {
        this.setAvailabilityPredicate(IPlayer::isFullArmorSetPutOn);
        return this.getSelf();
    }

    @Override
    default public T availableOnAnyArmorElement() {
        this.setAvailabilityPredicate(IPlayer::isAnyArmorElementPutOn);
        return this.getSelf();
    }

    @Override
    default public T availableIfSlotSet(EquipmentSlot slot) {
        this.setAvailabilityPredicate((player1, armor1) -> player1.isArmorElementPutOn((IArmor)armor1, slot));
        return this.getSelf();
    }

    @Override
    default public T availableIfSlotsSet(EquipmentSlot ... slots) {
        this.setAvailabilityPredicate((player1, armor1) -> player1.isAllArmorElementsPutOn((IArmor)armor1, slots));
        return this.getSelf();
    }

    @Override
    default public T unavailableIfNotModArmor(EquipmentSlot slot) {
        this.setUnavailabilityPredicate((player, armor) -> {
            ItemStack stack = player.getEntity().getItemBySlot(slot);
            return stack.isEmpty() || !(stack.getItem() instanceof ModArmor);
        });
        return this.getSelf();
    }

    @Override
    default public T showIcon() {
        this.setShowIcon(true);
        return this.getSelf();
    }

    @Override
    default public T hideIcon() {
        this.setShowIcon(false);
        return this.getSelf();
    }
}

