/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.scheduler;

import com.pekar.angelblock.events.scheduler.IScheduledTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;

public abstract class PlayerScheduler {
    private static final List<IScheduledTask<?>> tasks = new ArrayList();

    public static void add(IScheduledTask<?> task) {
        tasks.add(task);
    }

    public static void doOnTick(ServerPlayer player) {
        Iterator<IScheduledTask<?>> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            IScheduledTask<?> task = iterator.next();
            if (!task.belongsTo(player)) continue;
            task.decrementOrExecute();
            if (!task.isCompleted()) continue;
            iterator.remove();
        }
    }

    public static void cancelAll(ServerPlayer player) {
        Iterator<IScheduledTask<?>> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            IScheduledTask<?> task = iterator.next();
            if (!task.belongsTo(player)) continue;
            task.execute();
            iterator.remove();
        }
    }
}

