/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.network;

import com.pekar.angelblock.events.IEventHandler;
import com.pekar.angelblock.network.Packet;
import com.pekar.angelblock.network.PacketInfoProvider;
import com.pekar.angelblock.network.packets.ClientTickPacket;
import com.pekar.angelblock.network.packets.CreeperDetectedPacket;
import com.pekar.angelblock.network.packets.FindAllayPacketToClient;
import com.pekar.angelblock.network.packets.FindAllayPacketToServer;
import com.pekar.angelblock.network.packets.HoldingAngelRodPacket;
import com.pekar.angelblock.network.packets.KeyPressedPacket;
import com.pekar.angelblock.network.packets.PlaySoundPacket;
import com.pekar.angelblock.network.packets.ToolsModeChangePacket;
import com.pekar.angelblock.network.packets.UpdateArmorDurabilityPacketToClient;
import com.pekar.angelblock.network.packets.UpdateArmorDurabilityPacketToServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class NetworkingEventHandler
implements IEventHandler {
    @SubscribeEvent
    public void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").executesOn(HandlerThread.NETWORK);
        this.registerPacket(registrar, new CreeperDetectedPacket());
        this.registerPacket(registrar, new ClientTickPacket());
        this.registerPacket(registrar, new KeyPressedPacket());
        this.registerPacket(registrar, new ToolsModeChangePacket());
        this.registerPacket(registrar, new PlaySoundPacket());
        this.registerPacket(registrar, new HoldingAngelRodPacket());
        this.registerPacket(registrar, new UpdateArmorDurabilityPacketToServer());
        this.registerPacket(registrar, new UpdateArmorDurabilityPacketToClient());
        this.registerPacket(registrar, new FindAllayPacketToClient());
        this.registerPacket(registrar, new FindAllayPacketToServer());
    }

    private <T extends Packet> void registerPacket(PayloadRegistrar registrar, T packet) {
        PacketInfoProvider<T> packetInfoProvider = new PacketInfoProvider<T>(packet);
        if (packet.isServerToClient()) {
            registrar.playToClient(packetInfoProvider.getType(), packetInfoProvider.getStreamCodec(), packetInfoProvider.getHandler());
        } else {
            registrar.playToServer(packetInfoProvider.getType(), packetInfoProvider.getStreamCodec(), packetInfoProvider.getHandler());
        }
    }
}

