/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.ModSword;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class DiamithicSword
extends ModSword {
    public DiamithicSword(ModToolMaterial material, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = player.level();
        if (!this.canUseToolEffect(player)) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        if (player.hasEffect(PotionRegistry.SWORD_EXPLOSION_MODE_EFFECT)) {
            if (!level.isClientSide()) {
                this.explode(player, context.getHand(), level, pos);
            }
            return this.getToolInteractionResult(true, level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void additionalActionOnHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.hasEffect(PotionRegistry.SWORD_EXPLOSION_MODE_EFFECT)) {
            attacker.level().explode((Entity)attacker, target.getX() + 0.1, target.getY() + 0.9, target.getZ() + 0.1, 1.8f, false, Level.ExplosionInteraction.NONE);
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                ItemStack mainHandItem = attacker.getMainHandItem();
                InteractionHand interactionHand = !mainHandItem.isEmpty() && mainHandItem.getItem().equals(this) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                this.damageProperHandItemIfSurvivalIgnoreClient(player, interactionHand, attacker.level());
            }
        }
    }

    @Override
    public boolean isEnhanced() {
        return true;
    }

    @Override
    public boolean hasExplosionMode() {
        return true;
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        for (int i = 0; i <= 8; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1 || i == 3).styledAs(TextStyle.DarkGray, i >= 5 && i <= 7).apply();
        }
    }
}

