/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.items.ItemRegistry;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.WorkRod;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import com.pekar.angelblock.utils.SoundType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class Planter
extends WorkRod {
    public Planter(ModToolMaterial material, Item.Properties properties) {
        super(material, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        int offHandItemCountAfterUse;
        Player player = context.getPlayer();
        Level level = player.level();
        ItemStack offHandItemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        int offHandItemCountBeforeUse = offHandItemStack.getCount();
        BlockPos pos = context.getClickedPos();
        Item offHandItem = offHandItemStack.getItem();
        boolean success = false;
        if (offHandItem == Items.BONE_MEAL) {
            success = this.bonemealPlants(player, level, pos, context.getClickedFace());
        } else if (offHandItem instanceof BlockItem) {
            success = this.plantOffHandItems(player, level, pos, context.getClickedFace());
        } else if (offHandItem instanceof ShearsItem && (success = this.grabPlants(player, level, pos, 5, false))) {
            this.damageOffHandItemIfSurvivalIgnoreClient(player, level);
        }
        InteractionResult result = this.getToolInteractionResult(success, level.isClientSide());
        if ((result == InteractionResult.SUCCESS || result == InteractionResult.SUCCESS_SERVER) && (offHandItemCountAfterUse = offHandItemStack.getCount()) < offHandItemCountBeforeUse) {
            this.causePlayerExhaustion(player);
        }
        return result;
    }

    @Override
    public boolean mineBlock(ItemStack itemStack, Level level, BlockState blockState, BlockPos pos, LivingEntity livingEntity) {
        if (!level.isClientSide() && blockState.is(BlockRegistry.PLANTER_COMPATIBLE_TO_MINE) && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.grabPlants(player, level, pos, 3, true);
        }
        return true;
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.getBlock().defaultBlockState().is(BlockRegistry.PLANTER_COMPATIBLE_TO_MINE);
    }

    @Override
    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.FORTUNE);
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        for (int i = 0; i <= 9; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1 || i == 3).styledAs(TextStyle.Notice, i == 6).styledAs(TextStyle.ImportantNotice, i == 5).styledAs(TextStyle.DarkGray, i == 7 || i == 8).apply();
            if (i != 6) continue;
            tooltip.addEmptyLine();
        }
    }

    protected boolean grabPlants(Player player, Level level, BlockPos pos, int grabWidth, boolean shouldDrop) {
        int GRAB_LENGTH = 5;
        int GRAB_HALF_WIDTH = grabWidth / 2;
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        int x1 = 0;
        int x2 = 0;
        int z1 = 0;
        int z2 = 0;
        int incX = 1;
        int incZ = 1;
        switch (player.getDirection()) {
            case NORTH: {
                x1 = GRAB_HALF_WIDTH;
                x2 = GRAB_HALF_WIDTH + 1;
                z1 = 0;
                z2 = -5;
                incZ = -1;
                break;
            }
            case SOUTH: {
                x1 = GRAB_HALF_WIDTH;
                x2 = GRAB_HALF_WIDTH + 1;
                z1 = 0;
                z2 = 5;
                break;
            }
            case EAST: {
                x1 = 0;
                x2 = 5;
                z1 = GRAB_HALF_WIDTH;
                z2 = GRAB_HALF_WIDTH + 1;
                break;
            }
            case WEST: {
                x1 = 0;
                x2 = -5;
                incX = -1;
                z1 = GRAB_HALF_WIDTH;
                z2 = GRAB_HALF_WIDTH + 1;
            }
        }
        boolean haveAnyTransformed = false;
        ItemStack toolItemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        BlockState originBlockState = level.getBlockState(pos);
        Block originBlock = originBlockState.getBlock();
        int y = this.supportsFastGrabbing(originBlockState) ? posY : pos.above().getY();
        for (int x = posX - x1; x != posX + x2; x += incX) {
            for (int z = posZ - z1; z != posZ + z2; z += incZ) {
                boolean hasTransformed = this.grabPlant(player, level, originBlock, new BlockPos(x, y, z), toolItemStack, shouldDrop);
                if (!hasTransformed) continue;
                haveAnyTransformed = true;
            }
        }
        return haveAnyTransformed;
    }

    private boolean supportsFastGrabbing(BlockState blockState) {
        return blockState.getBlock() instanceof VegetationBlock || blockState.is(BlockRegistry.PLANTER_COMPATIBLE_TO_MINE);
    }

    protected boolean plantOffHandItems(Player player, Level level, BlockPos clickedPos, Direction facing) {
        if (facing != Direction.UP) {
            return false;
        }
        ItemStack seedInHand = player.getItemInHand(InteractionHand.OFF_HAND);
        Item item = seedInHand.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!seedInHand.is(ItemRegistry.PLANTER_COMPATIBLE_TO_PLANT)) {
            return false;
        }
        Block plantableBlock = blockItem.getBlock();
        int seedCount = seedInHand.getCount();
        int posX = clickedPos.getX();
        int posY = clickedPos.getY();
        int posZ = clickedPos.getZ();
        int shiftX = 0;
        int shiftZ = 0;
        int increment = 0;
        switch (player.getDirection()) {
            case NORTH: {
                shiftX = -1;
                shiftZ = -seedCount;
                increment = -1;
                break;
            }
            case SOUTH: {
                shiftX = 1;
                shiftZ = seedCount;
                increment = 1;
                break;
            }
            case EAST: {
                shiftX = seedCount;
                shiftZ = 1;
                increment = 1;
                break;
            }
            case WEST: {
                shiftX = -seedCount;
                shiftZ = -1;
                increment = -1;
            }
        }
        boolean haveAnyTransformed = false;
        ItemStack toolItemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        BlockState clickedBlockState = level.getBlockState(clickedPos);
        Block clickedBlock = clickedBlockState.getBlock();
        int y = this.supportsFastGrabbing(clickedBlockState) ? clickedPos.below().getY() : posY;
        Block originSoilBlock = level.getBlockState(new BlockPos(posX, y, posZ)).getBlock();
        for (int x = posX; x != posX + shiftX; x += increment) {
            for (int z = posZ; z != posZ + shiftZ; z += increment) {
                boolean hasTransformed = this.plantOffHandItem(player, level, clickedBlock, originSoilBlock, new BlockPos(x, y, z), facing, toolItemStack, plantableBlock);
                if (!hasTransformed) {
                    return haveAnyTransformed;
                }
                haveAnyTransformed = true;
            }
        }
        return haveAnyTransformed;
    }

    protected boolean bonemealPlants(Player player, Level level, BlockPos clickedPos, Direction facing) {
        int MAX_BONEMEALABLE_LENGTH = 64;
        int posX = clickedPos.getX();
        int posY = clickedPos.getY();
        int posZ = clickedPos.getZ();
        int shiftX = 0;
        int shiftZ = 0;
        int increment = 0;
        switch (player.getDirection()) {
            case NORTH: {
                shiftX = -1;
                shiftZ = -64;
                increment = -1;
                break;
            }
            case SOUTH: {
                shiftX = 1;
                shiftZ = 64;
                increment = 1;
                break;
            }
            case EAST: {
                shiftX = 64;
                shiftZ = 1;
                increment = 1;
                break;
            }
            case WEST: {
                shiftX = -64;
                shiftZ = -1;
                increment = -1;
            }
        }
        boolean haveAnyTransformed = false;
        ItemStack toolItemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        Block clickedBlock = level.getBlockState(clickedPos).getBlock();
        int y = clickedBlock instanceof BonemealableBlock ? posY : clickedPos.above().getY();
        Block originSoilBlock = level.getBlockState(new BlockPos(posX, y - 1, posZ)).getBlock();
        for (int x = posX; x != posX + shiftX; x += increment) {
            for (int z = posZ; z != posZ + shiftZ; z += increment) {
                boolean hasTransformed = this.bonemealPlant(player, level, clickedBlock, originSoilBlock, new BlockPos(x, y, z), facing, toolItemStack);
                if (!hasTransformed) {
                    return haveAnyTransformed;
                }
                haveAnyTransformed = true;
            }
        }
        return haveAnyTransformed;
    }

    private boolean grabPlant(Player player, Level level, Block originBlock, BlockPos pos, ItemStack toolItemStack, boolean shouldDrop) {
        BlockState blockState = level.getBlockState(pos);
        if (!this.supportsFastGrabbing(blockState) || this.supportsFastGrabbing(originBlock.defaultBlockState()) && originBlock != blockState.getBlock()) {
            return false;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (shouldDrop) {
                LootParams.Builder paramsBuilder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)toolItemStack).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player);
                List drops = blockState.getDrops(paramsBuilder);
                level.destroyBlock(pos, false);
                RandomSource random = level.getRandom();
                for (ItemStack drop : drops) {
                    double x = (double)pos.getX() + 0.5;
                    double y = (double)pos.getY() + 0.5;
                    double z = (double)pos.getZ() + 0.5;
                    Vec3 direction = player.position().subtract(x, y, z).normalize();
                    double scatter = 0.5;
                    double dx = direction.x + (random.nextDouble() - 0.5) * scatter;
                    double dy = direction.y + (random.nextDouble() - 0.5) * scatter;
                    double dz = direction.z + (random.nextDouble() - 0.5) * scatter;
                    Vec3 velocity = new Vec3(dx, dy, dz).normalize().scale(0.25);
                    ItemEntity itemEntity = new ItemEntity(level, x, y, z, drop);
                    itemEntity.setDeltaMovement(velocity);
                    itemEntity.setPickUpDelay(5);
                    level.addFreshEntity((Entity)itemEntity);
                }
            } else {
                level.destroyBlock(pos, false);
            }
        }
        return true;
    }

    private boolean plantOffHandItem(Player player, Level level, Block clickedBlock, Block originSoilBlock, BlockPos soilPosToPlantOn, Direction facing, ItemStack toolItemStack, Block blockToPlant) {
        InteractionResult result;
        BlockState blockAboveReplacingByPlantBlock;
        if (this.hasCriticalDamage(toolItemStack)) {
            return false;
        }
        BlockState soilBlockState = level.getBlockState(soilPosToPlantOn);
        Block soilBlock = soilBlockState.getBlock();
        if (soilBlock != originSoilBlock) {
            return false;
        }
        BlockState blockToReplaceByPlantBlockState = level.getBlockState(soilPosToPlantOn.above());
        if (!blockToReplaceByPlantBlockState.is(BlockRegistry.REPLACEABLE_BY_PLANTER)) {
            return blockToReplaceByPlantBlockState.getBlock() == clickedBlock;
        }
        ItemStack itemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        int itemCount = itemStack.getCount();
        if (itemCount < 1) {
            return false;
        }
        if (!blockToReplaceByPlantBlockState.isAir()) {
            level.destroyBlock(soilPosToPlantOn.above(), false);
        }
        if (!(blockAboveReplacingByPlantBlock = level.getBlockState(soilPosToPlantOn.above(2))).isAir() && blockAboveReplacingByPlantBlock.is(BlockRegistry.REPLACEABLE_BY_PLANTER)) {
            level.destroyBlock(soilPosToPlantOn.above(2), false);
        }
        if ((result = this.plant(player, level, soilPosToPlantOn, InteractionHand.OFF_HAND, facing, blockToPlant)).consumesAction()) {
            this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
            if (!player.isCreative()) {
                itemStack.setCount(itemCount - 1);
            }
        }
        return result.consumesAction();
    }

    private boolean bonemealPlant(Player player, Level level, Block clickedBlock, Block originSoilBlock, BlockPos posToBonemeal, Direction facing, ItemStack toolItemStack) {
        if (this.hasCriticalDamage(toolItemStack)) {
            return false;
        }
        Block soilBlock = level.getBlockState(posToBonemeal.below()).getBlock();
        if (soilBlock != originSoilBlock) {
            return false;
        }
        BlockState blockStateAtPosToBonemeal = level.getBlockState(posToBonemeal);
        Block blockToBonemeal = blockStateAtPosToBonemeal.getBlock();
        if (!(blockToBonemeal instanceof BonemealableBlock)) {
            return blockStateAtPosToBonemeal.isAir();
        }
        BonemealableBlock bonemealableBlock = (BonemealableBlock)blockToBonemeal;
        ItemStack itemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        int itemCount = itemStack.getCount();
        if (itemCount < 1) {
            return false;
        }
        if (bonemealableBlock.isValidBonemealTarget((LevelReader)level, posToBonemeal, blockStateAtPosToBonemeal)) {
            if (!level.isClientSide()) {
                bonemealableBlock.performBonemeal((ServerLevel)level, level.random, posToBonemeal, blockStateAtPosToBonemeal);
                if (bonemealableBlock.isBonemealSuccess(level, level.random, posToBonemeal, blockStateAtPosToBonemeal)) {
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                    if (!player.isCreative()) {
                        itemStack.setCount(itemCount - 1);
                    }
                }
            }
            this.utils.sound.playSoundByBlock(player, posToBonemeal, SoundType.BONEMEAL);
        }
        return true;
    }
}

