/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.ModShovel;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.properties.IMaterialProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class EnhancedShovel
extends ModShovel {
    public EnhancedShovel(ModToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties, IMaterialProperties materialProperties) {
        super(material, attackDamage, attackSpeed, properties, materialProperties);
    }

    @Override
    public boolean isEnhanced() {
        return true;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level;
        InteractionResult result = super.useOn(context);
        if (result == InteractionResult.FAIL) {
            return result;
        }
        Player player = context.getPlayer();
        return this.processAdditionalBlocks(player, level = player.level(), pos = context.getClickedPos(), context.getClickedFace()) ? this.getToolInteractionResult(true, level.isClientSide()) : result;
    }

    public boolean mineBlock(ItemStack itemStack, Level level, BlockState blockState, BlockPos pos, LivingEntity livingEntity) {
        if (!level.isClientSide) {
            this.mineAdditionalBlocks(level, pos, livingEntity);
        }
        return super.mineBlock(itemStack, level, blockState, pos, livingEntity);
    }

    protected void mineAdditionalBlocks(Level level, BlockPos pos, LivingEntity entityLiving) {
        int b;
        int a;
        if (!this.isToolEffective(entityLiving, pos)) {
            return;
        }
        if (!entityLiving.hasEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT)) {
            return;
        }
        BlockState blockState = level.getBlockState(pos);
        if (blockState.hasBlockEntity() || blockState != blockState.getBlock().defaultBlockState()) {
            return;
        }
        float originHardness = blockState.getBlock().defaultDestroyTime();
        if (originHardness == 0.0f) {
            return;
        }
        Direction facing = this.utils.player.getDirectionForShovel(entityLiving, pos);
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        int c = switch (facing) {
            case Direction.NORTH, Direction.SOUTH -> {
                a = 1;
                b = 1;
                yield 0;
            }
            case Direction.EAST, Direction.WEST -> {
                a = 0;
                b = 1;
                yield 1;
            }
            default -> {
                a = 1;
                b = 0;
                yield 1;
            }
        };
        for (int x = posX - a; x <= posX + a; ++x) {
            for (int y = posY - b; y <= posY + b; ++y) {
                for (int z = posZ - c; z <= posZ + c; ++z) {
                    if (x == posX && y == posY && z == posZ) continue;
                    this.onBlockMining(level, blockState, originHardness, new BlockPos(x, y, z), entityLiving);
                }
            }
        }
    }

    protected boolean processAdditionalBlocks(Player player, Level level, BlockPos pos, Direction facing) {
        int a2;
        if (facing != Direction.UP) {
            return false;
        }
        if (!player.hasEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT)) {
            return false;
        }
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        int b2 = switch (player.getDirection()) {
            case Direction.NORTH -> {
                int a1 = 1;
                a2 = 1;
                int b1 = 3;
                yield 1;
            }
            case Direction.SOUTH -> {
                int a1 = 1;
                a2 = 1;
                int b1 = 1;
                yield 3;
            }
            case Direction.EAST -> {
                int a1 = 1;
                a2 = 3;
                int b1 = 1;
                yield 1;
            }
            case Direction.WEST -> {
                int a1 = 3;
                a2 = 1;
                int b1 = 1;
                yield 1;
            }
            default -> {
                int a1 = 1;
                a2 = 1;
                int b1 = 1;
                yield 1;
            }
        };
        boolean haveAnyTransformed = false;
        for (int x = posX - a1; x <= posX + a2; ++x) {
            for (int z = posZ - b1; z <= posZ + b2; ++z) {
                boolean hasTransformed;
                if (x == posX && z == posZ || !(hasTransformed = this.onBlockProcessing(player, level, pos, new BlockPos(x, posY, z), facing))) continue;
                haveAnyTransformed = true;
            }
        }
        return haveAnyTransformed;
    }

    protected void onBlockMining(Level level, BlockState originBlockState, float originHardness, BlockPos pos, LivingEntity entityLiving) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (blockState.hasBlockEntity() || blockState != block.defaultBlockState()) {
            return;
        }
        float hardness = block.defaultDestroyTime();
        if (hardness <= originHardness && this.isToolEffective(entityLiving, pos) && (this.materialProperties.isSafeToBreak(entityLiving, pos) || entityLiving.isShiftKeyDown()) && this.utils.player.destroyBlockByMainHandTool(level, pos, entityLiving, blockState, block)) {
            this.damageMainHandItem(1, entityLiving);
        }
    }
}

