/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events;

import com.pekar.angelblock.keybinds.KeyRegistry;
import com.pekar.angelblock.network.ClientToServerPacket;
import com.pekar.angelblock.network.packets.KeyPressedPacket;
import com.pekar.angelblock.network.packets.ToolsModeChangePacket;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;

@EventBusSubscriber(modid="angelblock", value={Dist.CLIENT})
public class KeyboardMouseEvents {
    private static final Map<String, Long> lastTime = new HashMap<String, Long>();

    public static void initStatic() {
    }

    @SubscribeEvent
    public static void onKeyInputEvent(InputEvent.Key event) {
        String keyName;
        if (KeyRegistry.JUMP_BOOST.isDown()) {
            keyName = KeyRegistry.JUMP_BOOST.getName();
            KeyboardMouseEvents.trySendPacket(keyName, new KeyPressedPacket(keyName));
        }
        if (KeyRegistry.NIGHT_VISION.isDown()) {
            keyName = KeyRegistry.NIGHT_VISION.getName();
            KeyboardMouseEvents.trySendPacket(keyName, new KeyPressedPacket(keyName));
        }
        if (KeyRegistry.GLOWING.isDown()) {
            keyName = KeyRegistry.GLOWING.getName();
            KeyboardMouseEvents.trySendPacket(keyName, new KeyPressedPacket(keyName));
        }
        if (KeyRegistry.REGENERATION.isDown()) {
            keyName = KeyRegistry.REGENERATION.getName();
            KeyboardMouseEvents.trySendPacket(keyName, new KeyPressedPacket(keyName));
        }
        if (KeyRegistry.LEVITATION.isDown()) {
            keyName = KeyRegistry.LEVITATION.getName();
            KeyboardMouseEvents.trySendPacket(keyName, new KeyPressedPacket(keyName));
        }
        if (KeyRegistry.SWORD_EFFECT.isDown()) {
            keyName = KeyRegistry.SWORD_EFFECT.getName();
            KeyboardMouseEvents.trySendPacket(keyName, new ToolsModeChangePacket());
        }
        if (KeyRegistry.SUPER_JUMP.isDown()) {
            keyName = KeyRegistry.SUPER_JUMP.getName();
            KeyboardMouseEvents.trySendPacket(keyName, new KeyPressedPacket(keyName));
        }
    }

    private static synchronized void trySendPacket(String keyName, ClientToServerPacket packet) {
        long time1;
        if (keyName == null) {
            return;
        }
        long time2 = Clock.systemUTC().millis();
        Long last = lastTime.get(keyName);
        if (last != null && time2 - (time1 = last.longValue()) < 200L) {
            return;
        }
        lastTime.put(keyName, time2);
        packet.sendToServer();
    }
}

