/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.cleaners;

import com.pekar.angelblock.events.cleaners.AllayManager;
import com.pekar.angelblock.events.cleaners.TargetBehavior;
import com.pekar.angelblock.events.cleaners.TrackedAllay;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.allay.Allay;

class AllayTargetBehavior
extends TargetBehavior<TrackedAllay> {
    private static final double DistanceToDecrease = 16.0;
    private static final double DistanceToRemoveImmediately = 60.0;

    public AllayTargetBehavior(TrackedAllay target) {
        super(target);
    }

    @Override
    public boolean shouldDecrement() {
        return this.getDistanceToOwner() > 16.0;
    }

    @Override
    public boolean shouldReset() {
        if (this.getDistanceToOwner() <= 16.0) {
            return true;
        }
        return this.isPersistent();
    }

    @Override
    public boolean shouldRemove() {
        if (AllayTargetBehavior.isDied((Allay)((TrackedAllay)this.target).getTargetInstance())) {
            return true;
        }
        if (this.isPersistent()) {
            return false;
        }
        if (((TrackedAllay)this.target).getTicksLeft() <= 0) {
            return true;
        }
        double distanceToOwner = this.getDistanceToOwner();
        return distanceToOwner > 60.0;
    }

    @Override
    public boolean shouldUntrack() {
        return ((Allay)((TrackedAllay)this.target).getTargetInstance()).hasCustomName();
    }

    @Override
    public boolean canBeRemovedOnClean() {
        if (AllayTargetBehavior.isDied((Allay)((TrackedAllay)this.target).getTargetInstance())) {
            return true;
        }
        return !this.isPersistent();
    }

    @Override
    public void onRemove() {
        AllayManager.removeFromStorage((TrackedAllay)this.target);
    }

    @Override
    public void onUnableToRemove() {
        if (!((Allay)((TrackedAllay)this.target).getTargetInstance()).hasCustomName()) {
            AllayManager.store((TrackedAllay)this.target);
        }
    }

    private double getDistanceToOwner() {
        return ((TrackedAllay)this.target).getOwner().distanceTo((Entity)((TrackedAllay)this.target).getTargetInstance());
    }

    private boolean isPersistent() {
        Allay allay = (Allay)((TrackedAllay)this.target).getTargetInstance();
        Entity.RemovalReason removalReason = allay.getRemovalReason();
        if (allay.isRemoved() && removalReason != null && !removalReason.shouldDestroy()) {
            return true;
        }
        return allay.isHolding(stack -> !stack.isEmpty()) || allay.hasCustomName();
    }

    private static boolean isDied(Allay targetInstance) {
        Entity.RemovalReason removalReason = targetInstance.getRemovalReason();
        return targetInstance.isRemoved() && removalReason != null && removalReason.shouldDestroy();
    }
}

