/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.effect;

import com.pekar.angelblock.events.effect.IExtendedSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingEffectSynchronizer;
import com.pekar.angelblock.events.effect.State;
import java.util.ArrayList;
import java.util.List;

public class SwitchingEffectSynchronizer
implements ISwitchingEffectSynchronizer {
    private final IExtendedSwitchingArmorEffect masterEffect;
    private final List<IExtendedSwitchingArmorEffect> dependentEffects = new ArrayList<IExtendedSwitchingArmorEffect>();
    private final List<IExtendedSwitchingArmorEffect> dependentInvertedEffects = new ArrayList<IExtendedSwitchingArmorEffect>();

    public SwitchingEffectSynchronizer(IExtendedSwitchingArmorEffect masterEffect) {
        this.masterEffect = masterEffect;
    }

    @Override
    public final boolean isOn() {
        return this.masterEffect.isOn();
    }

    @Override
    public final State getState() {
        return this.masterEffect.getState();
    }

    @Override
    public void updateAvailability() {
        this.masterEffect.updateAvailability();
        for (IExtendedSwitchingArmorEffect effect : this.dependentEffects) {
            effect.updateAvailability();
        }
        for (IExtendedSwitchingArmorEffect effect : this.dependentInvertedEffects) {
            effect.updateAvailability();
        }
    }

    @Override
    public void updateActivity() {
        this.masterEffect.updateActivity();
        this.updateDependentEffectsActivity();
    }

    @Override
    public void updateActivity(int masterEffectAmplifier) {
        this.masterEffect.updateActivity(masterEffectAmplifier);
        this.updateDependentEffectsActivity();
    }

    @Override
    public void updateDependentEffectsActivity() {
        for (IExtendedSwitchingArmorEffect effect : this.dependentEffects) {
            if (effect.isOn() != this.masterEffect.isOn() && effect.isAvailable()) {
                effect.trySwitch();
                continue;
            }
            effect.updateActivity();
        }
        for (IExtendedSwitchingArmorEffect effect : this.dependentInvertedEffects) {
            if (effect.isOn() == this.masterEffect.isOn() && effect.isAvailable()) {
                effect.trySwitch();
                continue;
            }
            effect.updateActivity();
        }
    }

    @Override
    public boolean isMasterActive() {
        return this.masterEffect.isActive();
    }

    @Override
    public boolean isMasterAvailable() {
        return this.masterEffect.isAvailable();
    }

    @Override
    public void trySwitch() {
        this.masterEffect.trySwitch();
        this.switchDependentEffects();
    }

    @Override
    public final void trySwitchTo(boolean switchOn) {
        if (switchOn) {
            this.trySwitchOn();
        } else {
            this.trySwitchOff();
        }
    }

    @Override
    public void trySwitchOff() {
        this.masterEffect.trySwitchOff();
        for (IExtendedSwitchingArmorEffect effect : this.dependentEffects) {
            effect.trySwitchOff();
        }
        for (IExtendedSwitchingArmorEffect effect : this.dependentInvertedEffects) {
            effect.trySwitchOn();
        }
    }

    @Override
    public void trySwitchOn() {
        this.masterEffect.trySwitchOn();
        for (IExtendedSwitchingArmorEffect effect : this.dependentEffects) {
            effect.trySwitchOn();
        }
        for (IExtendedSwitchingArmorEffect effect : this.dependentInvertedEffects) {
            effect.trySwitchOff();
        }
    }

    @Override
    public void trySwitch(int masterEffectAmplifier) {
        this.masterEffect.trySwitch(masterEffectAmplifier);
        this.switchDependentEffects();
    }

    @Override
    public void trySwitchOn(int masterEffectAmplifier) {
        this.masterEffect.trySwitchOn(masterEffectAmplifier);
        for (IExtendedSwitchingArmorEffect effect : this.dependentEffects) {
            effect.trySwitchOn();
        }
        for (IExtendedSwitchingArmorEffect effect : this.dependentInvertedEffects) {
            effect.trySwitchOff();
        }
    }

    @Override
    public void updateSwitchState() {
        this.masterEffect.updateSwitchState();
        this.updateDependentSwitchStates();
    }

    @Override
    public void addDependentEffect(IExtendedSwitchingArmorEffect effect) {
        this.dependentEffects.add(effect);
        effect.setSwitchState(this.masterEffect.isOn());
    }

    @Override
    public void addDependentInvertedEffect(IExtendedSwitchingArmorEffect effect) {
        this.dependentInvertedEffects.add(effect);
        effect.setSwitchState(!this.masterEffect.isOn());
    }

    private void switchDependentEffects() {
        boolean isMasterEffectAvailable = this.masterEffect.isAvailable();
        if (isMasterEffectAvailable) {
            if (this.masterEffect.isOn()) {
                for (IExtendedSwitchingArmorEffect effect : this.dependentEffects) {
                    effect.trySwitchOn();
                }
                for (IExtendedSwitchingArmorEffect effect : this.dependentInvertedEffects) {
                    effect.trySwitchOff();
                }
            } else {
                for (IExtendedSwitchingArmorEffect effect : this.dependentEffects) {
                    effect.trySwitchOff();
                }
                for (IExtendedSwitchingArmorEffect effect : this.dependentInvertedEffects) {
                    effect.trySwitchOn();
                }
            }
        } else {
            for (IExtendedSwitchingArmorEffect effect : this.dependentEffects) {
                effect.trySwitch();
            }
            for (IExtendedSwitchingArmorEffect effect : this.dependentInvertedEffects) {
                effect.trySwitch();
            }
        }
    }

    private void updateDependentSwitchStates() {
        for (IExtendedSwitchingArmorEffect effect : this.dependentEffects) {
            effect.setSwitchState(this.masterEffect.isOn());
        }
        for (IExtendedSwitchingArmorEffect effect : this.dependentInvertedEffects) {
            effect.setSwitchState(!this.masterEffect.isOn());
        }
    }
}

