/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.tools.ModSword;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LimonitePrimarySword
extends ModSword {
    public LimonitePrimarySword(ModToolMaterial material, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    @Override
    protected void additionalActionOnHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.addEffect(new MobEffectInstance(MobEffects.POISON, 80, 0, true, true));
        target.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 100, 0, true, true));
    }

    @Override
    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        if (this.hasCriticalDamage(itemStack)) {
            return 1.0f;
        }
        Block block = blockState.getBlock();
        if (block == Blocks.COBWEB) {
            return 60.0f;
        }
        if (block == Blocks.CACTUS) {
            return 40.0f;
        }
        return super.getDestroySpeed(itemStack, blockState);
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip, flag)) {
            return;
        }
        for (int i = 0; i <= 6; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1).styledAs(TextStyle.DarkGray, i == 5).apply();
        }
    }
}

