/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.cleaners;

import com.pekar.angelblock.events.cleaners.ITargetBehavior;
import com.pekar.angelblock.events.cleaners.ITrackedTarget;
import net.minecraft.world.entity.player.Player;

public abstract class TrackedTarget<T>
implements ITrackedTarget {
    private final T targetInstance;
    private final Player owner;
    private int ticksLeftBeforeRemoving;
    private final int ticksBeforeRemoving;
    private ITargetBehavior behavior;

    public TrackedTarget(T targetInstance, Player owner, int ticksBeforeRemoving) {
        this.targetInstance = targetInstance;
        this.owner = owner;
        this.ticksBeforeRemoving = ticksBeforeRemoving;
        this.ticksLeftBeforeRemoving = ticksBeforeRemoving;
    }

    @Override
    public final ITargetBehavior getBehavior() {
        if (this.behavior == null) {
            this.behavior = this.createBehavior();
        }
        return this.behavior;
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public int getTicksLeft() {
        return this.ticksLeftBeforeRemoving;
    }

    @Override
    public void decrementTick() {
        --this.ticksLeftBeforeRemoving;
    }

    @Override
    public void resetTick() {
        this.ticksLeftBeforeRemoving = this.ticksBeforeRemoving;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TrackedTarget)) {
            return false;
        }
        TrackedTarget other = (TrackedTarget)obj;
        return this.getId().equals(other.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    protected final T getTargetInstance() {
        return this.targetInstance;
    }

    protected abstract ITargetBehavior createBehavior();
}

