/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.EnhancedAxe;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.properties.LimoniteAxeProperties;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LimoniteAxe
extends EnhancedAxe {
    public LimoniteAxe(ModToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties, new LimoniteAxeProperties());
    }

    @Override
    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        if (this.hasCriticalDamage(itemStack)) {
            return 1.0f;
        }
        if (blockState.getBlock() == Blocks.CACTUS) {
            return 12.0f;
        }
        return super.getDestroySpeed(itemStack, blockState);
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        for (int i = 0; i <= 7; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1).styledAs(TextStyle.Notice, i == 3).styledAs(TextStyle.DarkGray, i == 6).apply();
        }
    }

    @Override
    protected void mineAdditionalBlocks(ItemStack itemStack, Level level, BlockPos pos, LivingEntity entityLiving) {
        if (!this.isEnhanced() || !entityLiving.hasEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT)) {
            return;
        }
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!this.isToolEffective(entityLiving, pos)) {
            return;
        }
        float initialHardness = block.defaultDestroyTime();
        if (initialHardness != 0.0f && this.isCorrectToolForDrops(itemStack, blockState) && !this.isCompatiblePlant(itemStack, blockState)) {
            int increment = 1;
            while (this.canProceed(entityLiving, pos.above(increment))) {
                this.onBlockMining(itemStack, level, blockState, initialHardness, pos.above(increment++), entityLiving);
            }
            increment = 1;
            while (this.canProceed(entityLiving, pos.below(increment))) {
                this.onBlockMining(itemStack, level, blockState, initialHardness, pos.below(increment++), entityLiving);
            }
        }
        if (this.isCompatiblePlant(itemStack, blockState)) {
            super.mineAdditionalBlocks(itemStack, level, pos, entityLiving);
        }
    }

    private boolean canProceed(LivingEntity entityLiving, BlockPos pos) {
        return !entityLiving.level().isEmptyBlock(pos) && this.isToolEffective(entityLiving, pos);
    }
}

