/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.blocks;

import com.pekar.angelblock.Main;
import com.pekar.angelblock.blocks.AirBlock;
import com.pekar.angelblock.blocks.AngelBlock;
import com.pekar.angelblock.blocks.AngelRodBlock;
import com.pekar.angelblock.blocks.CrackedEndStoneBlock;
import com.pekar.angelblock.blocks.CrackedObsidianBlock;
import com.pekar.angelblock.blocks.DevilBlock;
import com.pekar.angelblock.blocks.GreenDiamondBlock;
import com.pekar.angelblock.blocks.GunpowderBlock;
import com.pekar.angelblock.blocks.InactiveAngelBlock;
import com.pekar.angelblock.blocks.NetherBarsBlock;
import com.pekar.angelblock.blocks.block_items.AngelBlockItem;
import com.pekar.angelblock.blocks.block_items.DevilBlockItem;
import com.pekar.angelblock.blocks.block_items.GreenDiamondOreBlockItem;
import com.pekar.angelblock.blocks.block_items.GunpowderBlockItem;
import com.pekar.angelblock.blocks.block_items.InactiveAngelBlockItem;
import com.pekar.angelblock.blocks.block_items.ModBlockItem;
import com.pekar.angelblock.blocks.block_items.ModBlockItemWithHoverText;
import com.pekar.angelblock.blocks.block_items.NetherBarsBlockItem;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;

public class BlockRegistry {
    public static final TagKey<Block> PLANTER_COMPATIBLE_TO_MINE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)"planter_compatible_to_mine"));
    public static final TagKey<Block> PLANTER_COMPATIBLE_TO_PLANT = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)"planter_compatible_to_plant"));
    public static final TagKey<Block> REPLACEABLE_BY_PLANTER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)"planter_replaceables"));
    public static final TagKey<Block> TRACK_LAYER_COMPATIBLE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)"track_layer_compatible"));
    public static final DeferredBlock<Block> CRACKED_ENDSTONE = BlockRegistry.register("cracked_endstone_block", CrackedEndStoneBlock::new, ModBlockItemWithHoverText::new, BlockBehaviour.Properties.of().strength(0.5f).sound(SoundType.SNOW).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> CRACKED_OBSIDIAN = BlockRegistry.register("cracked_obsidian_block", CrackedObsidianBlock::new, ModBlockItemWithHoverText::new, BlockBehaviour.Properties.of().strength(10.0f).sound(SoundType.METAL).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> DIAMOND_POWDER_BLOCK = BlockRegistry.register("diamond_powder_block", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).strength(0.7f, 9.0f).sound(SoundType.SNOW));
    public static final DeferredBlock<Block> OBSIDIAN_POWDER_BLOCK = BlockRegistry.register("obsidian_powder_block", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).strength(0.7f, 9.0f));
    public static final DeferredBlock<Block> ENDSTONE_POWDER_BLOCK = BlockRegistry.register("endstone_powder_block", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).strength(0.7f, 9.0f).sound(SoundType.SNOW));
    public static final DeferredBlock<Block> SALTPETER_BLOCK = BlockRegistry.register("saltpeter_block", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).strength(0.7f, 9.0f).sound(SoundType.SNOW));
    public static final DeferredBlock<Block> DIAMITHIC_MATERIAL_BLOCK = BlockRegistry.register("diamithic_material_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.7f, 9.0f));
    public static final DeferredBlock<Block> RENDELITHIC_MATERIAL_BLOCK = BlockRegistry.register("rendelithic_material_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.7f, 9.0f));
    public static final DeferredBlock<Block> LIMONITE_MATERIAL_BLOCK = BlockRegistry.register("limonite_material_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.7f, 9.0f));
    public static final DeferredBlock<Block> LAPIS_MATERIAL_BLOCK = BlockRegistry.register("lapis_material_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.7f, 9.0f));
    public static final DeferredBlock<Block> SUPER_MATERIAL_BLOCK = BlockRegistry.register("super_material_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.7f, 9.0f));
    public static final DeferredBlock<Block> FLYING_MATERIAL_BLOCK = BlockRegistry.register("flying_material_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.7f, 9.0f));
    public static final DeferredBlock<Block> INACTIVE_ANGEL_BLOCK = BlockRegistry.register("inactive_angel_block", InactiveAngelBlock::new, InactiveAngelBlockItem::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(1.5f, 1200.0f));
    public static final DeferredBlock<Block> ANGEL_BLOCK = BlockRegistry.register("angel_block", AngelBlock::new, AngelBlockItem::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(1.5f, 1200.0f).lightLevel(state -> 15));
    public static final DeferredBlock<Block> DEVIL_BLOCK = BlockRegistry.register("devil_block", DevilBlock::new, DevilBlockItem::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(10.0f, 1200.0f).lightLevel(blockState -> 10));
    public static final DeferredBlock<Block> ANGEL_ROD_BLOCK = BlockRegistry.registerSkipTab("angel_rod_block", AngelRodBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHTNING_ROD).strength(0.1f, 1200.0f).sound(SoundType.COPPER).lightLevel(state -> 15));
    public static final DeferredBlock<Block> GREEN_DIAMOND_ORE = BlockRegistry.register("green_diamond_ore", GreenDiamondBlock::new, GreenDiamondOreBlockItem::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_ORE).strength(1.0f).lightLevel(state -> 6).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> GUNPOWDER_BLOCK = BlockRegistry.register("gunpowder_block", GunpowderBlock::new, GunpowderBlockItem::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).sound(SoundType.SNOW).strength(0.2f));
    public static final DeferredBlock<Block> NETHER_BARS = BlockRegistry.register("nether_bars_block", NetherBarsBlock::new, NetherBarsBlockItem::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS).strength(10.0f, 1200.0f).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> DESTROYING_DIAMOND_POWDER_BLOCK = BlockRegistry.registerSkipTab("destroying_diamond_powder_block", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_PRISMARINE_SHARD_BLOCK = BlockRegistry.registerSkipTab("destroying_prismarine_shard_block", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_PRISMARINE_CRYSTALS = BlockRegistry.registerSkipTab("destroying_prismarine_crystals", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_WHITE_WOOL_BY_POTION = BlockRegistry.registerSkipTab("destroying_white_wool_by_potion", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_BLAZE_POWDER = BlockRegistry.registerSkipTab("destroying_blaze_powder", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_WHITE_WOOL_BY_ROD = BlockRegistry.registerSkipTab("destroying_white_wool_by_rod", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_ORANGE_WOOL = BlockRegistry.registerSkipTab("destroying_orange_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_MAGENTA_WOOL = BlockRegistry.registerSkipTab("destroying_magenta_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_LIGHT_BLUE_WOOL = BlockRegistry.registerSkipTab("destroying_light_blue_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_YELLOW_WOOL = BlockRegistry.registerSkipTab("destroying_yellow_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_LIME_WOOL = BlockRegistry.registerSkipTab("destroying_lime_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_PINK_WOOL = BlockRegistry.registerSkipTab("destroying_pink_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_GRAY_WOOL = BlockRegistry.registerSkipTab("destroying_gray_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_LIGHT_GRAY_WOOL = BlockRegistry.registerSkipTab("destroying_light_gray_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_CYAN_WOOL = BlockRegistry.registerSkipTab("destroying_cyan_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_PURPLE_WOOL = BlockRegistry.registerSkipTab("destroying_purple_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_BLUE_WOOL = BlockRegistry.registerSkipTab("destroying_blue_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_BROWN_WOOL = BlockRegistry.registerSkipTab("destroying_brown_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_GREEN_WOOL = BlockRegistry.registerSkipTab("destroying_green_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_RED_WOOL = BlockRegistry.registerSkipTab("destroying_red_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_BLACK_WOOL = BlockRegistry.registerSkipTab("destroying_black_wool", AirBlock::new);
    public static final DeferredBlock<Block> DESTROYING_SALTPETER = BlockRegistry.registerSkipTab("destroying_saltpeter", AirBlock::new);

    public static void initStatic() {
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> blockSupplier) {
        DeferredBlock blockObject = Main.BLOCKS.register(name, blockSupplier);
        Main.ITEMS.registerItem(name, p -> new ModBlockItem((Block)blockObject.get(), (Item.Properties)p));
        return blockObject;
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> blockSupplier) {
        DeferredBlock blockObject = Main.BLOCKS.registerBlock(name, blockSupplier);
        Main.ITEMS.registerItem(name, p -> new ModBlockItem((Block)blockObject.get(), (Item.Properties)p));
        return blockObject;
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> blockSupplier, BlockBehaviour.Properties properties) {
        DeferredBlock blockObject = Main.BLOCKS.registerBlock(name, blockSupplier, () -> properties);
        Main.ITEMS.registerItem(name, p -> new ModBlockItem((Block)blockObject.get(), (Item.Properties)p));
        return blockObject;
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> blockSupplier, BiFunction<Block, Item.Properties, ? extends ModBlockItem> blockItemSupplier, BlockBehaviour.Properties blockProperties) {
        DeferredBlock blockObject = Main.BLOCKS.registerBlock(name, blockSupplier, () -> blockProperties);
        Main.ITEMS.registerItem(name, p -> (ModBlockItem)((Object)((Object)blockItemSupplier.apply((Block)blockObject.get(), (Item.Properties)p))));
        return blockObject;
    }

    private static <T extends Block> DeferredBlock<T> registerSkipTab(String name, Supplier<T> supplier) {
        return Main.BLOCKS.register(name, supplier);
    }

    private static <T extends Block> DeferredBlock<T> registerSkipTab(String name, Function<BlockBehaviour.Properties, T> supplier) {
        return Main.BLOCKS.registerBlock(name, supplier);
    }

    private static <T extends Block> DeferredBlock<T> registerSkipTab(String name, Function<BlockBehaviour.Properties, T> supplier, BlockBehaviour.Properties properties) {
        return Main.BLOCKS.registerBlock(name, supplier, () -> properties);
    }
}

