/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.effect;

import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.effect.EffectSetup;
import com.pekar.angelblock.events.effect.IArmorEffect;
import com.pekar.angelblock.events.effect.State;
import com.pekar.angelblock.events.player.IModMobEffectInstance;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.events.player.ModMobEffectInstance;
import java.util.function.BiPredicate;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

abstract class ArmorEffect<T extends IArmorEffect>
implements EffectSetup<T>,
IArmorEffect {
    protected final IPlayer player;
    protected final IArmor armor;
    protected final Holder<MobEffect> effectType;
    private State state = State.OFF;
    private boolean isAvailable;
    private boolean isNotAvailable;
    protected final int defaultAmplifier;
    private boolean showIcon;
    private IModMobEffectInstance effectInstance;
    private BiPredicate<IPlayer, IArmor> availabilityPredicate = (p, a) -> false;
    private BiPredicate<IPlayer, IArmor> unavailabilityPredicate = (p, a) -> !this.availabilityPredicate.test((IPlayer)p, (IArmor)a);

    protected ArmorEffect(IPlayer player, IArmor armor, Holder<MobEffect> effectType, int defaultAmplifier) {
        this.player = player;
        this.armor = armor;
        this.effectType = effectType;
        this.defaultAmplifier = defaultAmplifier;
    }

    @Override
    public final State getState() {
        return this.state;
    }

    @Override
    public final boolean isActive() {
        return this.player.hasArmorEffect(this.effectType) && this.effectInstance != null && this.effectInstance.equals(this.player.getEffectInstance(this.effectType));
    }

    @Override
    public boolean isAnotherActive() {
        return this.player.isEffectActive(this.effectType) && !this.isActive();
    }

    @Override
    public boolean isAnyActive() {
        return this.player.isEffectActive(this.effectType);
    }

    @Override
    public final boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    public final boolean isUnavailable() {
        return this.isNotAvailable;
    }

    @Override
    public final void updateAvailability() {
        this.isAvailable = this.availabilityPredicate.test(this.player, this.armor);
        this.isNotAvailable = this.unavailabilityPredicate.test(this.player, this.armor);
    }

    @Override
    public void updateActivity() {
        this.updateActivity(this.defaultAmplifier, -1);
    }

    @Override
    public final void updateSwitchState() {
        boolean canHandleEffect = this.isAvailable() && this.player.hasArmorEffect(this.effectType);
        this.setSwitchState(canHandleEffect);
    }

    protected void setSwitchState(boolean isOn) {
        this.setState(isOn ? State.ON : State.OFF);
    }

    protected boolean isOn() {
        return this.state.isOn();
    }

    protected final void updateActivity(int amplifier, int duration) {
        if (this.isAvailable() && this.isOn()) {
            if (!this.isActive() || this.shouldPersist()) {
                this.effectInstance = this.setEffect(amplifier, duration);
            }
        } else {
            this.tryRemove();
        }
    }

    protected boolean shouldPersist() {
        return false;
    }

    protected abstract IModMobEffectInstance setEffect(int var1, int var2);

    protected final void setState(State state) {
        this.state = state;
    }

    protected void tryActivateInternal(int amplifier, int duration) {
        this.setState(State.ON);
        this.updateActivity(amplifier, duration);
    }

    private void tryRemove(boolean forceRemove) {
        if (this.canClearEffect()) {
            if (this.isActive() || this.isAnyActive() && (forceRemove || this.isAvailable() && this.isInfinite() && !this.isCrystalEffect())) {
                this.player.clearEffect(this.effectType);
                this.effectInstance = null;
            }
            if (this.state.isOn()) {
                this.setState(State.OFF);
            }
        }
    }

    protected void tryRemove() {
        this.tryRemove(false);
    }

    @Override
    public final void forceRemove() {
        this.tryRemove(true);
    }

    protected boolean canClearEffect() {
        return true;
    }

    protected boolean getShowIcon() {
        return this.showIcon;
    }

    protected final void clearEffectInstance() {
        this.effectInstance = null;
    }

    @Override
    public final void setShowIcon(boolean value) {
        this.showIcon = value;
    }

    @Override
    public final void setAvailabilityPredicate(BiPredicate<IPlayer, IArmor> value) {
        this.availabilityPredicate = value;
    }

    @Override
    public final BiPredicate<IPlayer, IArmor> getAvailabilityPredicate() {
        return this.availabilityPredicate;
    }

    @Override
    public void setUnavailabilityPredicate(BiPredicate<IPlayer, IArmor> value) {
        this.unavailabilityPredicate = value;
    }

    @Override
    public BiPredicate<IPlayer, IArmor> getUnavailabilityPredicate() {
        return this.unavailabilityPredicate;
    }

    @Override
    public final boolean isInfinite() {
        return this.player.getEffectInstance(this.effectType).isInfiniteDuration();
    }

    private boolean isCrystalEffect() {
        ModMobEffectInstance modMobEffectInstance;
        MobEffectInstance mobEffectInstance = this.player.getEffectInstance(this.effectType);
        return mobEffectInstance instanceof ModMobEffectInstance && (modMobEffectInstance = (ModMobEffectInstance)mobEffectInstance).isCrystalEffect();
    }
}

