/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.mojang.datafixers.util.Pair;
import com.pekar.angelblock.tools.IModToolEnhanceable;
import com.pekar.angelblock.tools.ModTool;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.properties.DefaultMaterialProperties;
import com.pekar.angelblock.tools.properties.IMaterialProperties;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import com.pekar.angelblock.utils.SoundType;
import com.pekar.angelblock.utils.Utils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class ModHoe
extends ModTool
implements IModToolEnhanceable {
    protected final IMaterialProperties materialProperties;
    protected final Utils utils = new Utils();
    private final ModToolMaterial material;

    public static ModHoe createPrimary(ModToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        return new ModHoe(material, attackDamage, attackSpeed, properties, new DefaultMaterialProperties());
    }

    public ModHoe(ModToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties, IMaterialProperties materialProperties) {
        super(material, (TagKey<Block>)BlockTags.MINEABLE_WITH_HOE, attackDamage, attackSpeed, properties);
        this.materialProperties = materialProperties;
        this.material = material;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        BlockPos upPos;
        InteractionResult result = this.useOnBasic(context);
        if (result == InteractionResult.FAIL) {
            return result;
        }
        Player player = context.getPlayer();
        Level level = player.level();
        if (level.isWaterAt(upPos = (pos = context.getClickedPos()).above()) || level.isEmptyBlock(upPos) && (this.utils.blocks.types.isFarmTypeBlock(level, upPos.north()) && this.utils.blocks.types.isFarmTypeBlock(level, upPos.south()) || this.utils.blocks.types.isFarmTypeBlock(level, upPos.east()) && this.utils.blocks.types.isFarmTypeBlock(level, upPos.west()))) {
            if (!level.isClientSide()) {
                level.setBlock(upPos, Blocks.WATER.defaultBlockState(), 11);
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
            }
            this.utils.sound.playSoundByBlock(player, pos, SoundType.WATER_PLACED);
            return this.getToolInteractionResult(true, level.isClientSide());
        }
        if (level.isEmptyBlock(upPos) && context.getClickedFace() == Direction.UP) {
            return this.changePodzolToDirt(player, level, pos) ? this.getToolInteractionResult(true, level.isClientSide()) : result;
        }
        return result;
    }

    public void setDamage(ItemStack stack, int damage) {
        int modifiedDamage = Mth.clamp((int)damage, (int)0, (int)(stack.getMaxDamage() - this.getCriticalDurability()));
        stack.set(DataComponents.DAMAGE, (Object)modifiedDamage);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return !this.hasCriticalDamage(stack) && ItemAbilities.DEFAULT_HOE_ACTIONS.contains(itemAbility);
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip, flag)) {
            return;
        }
        for (int i = 0; i <= 5; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1).styledAs(TextStyle.DarkGray, i == 4).apply();
        }
    }

    protected boolean changePodzolToDirt(Player player, Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block == Blocks.PODZOL) {
            if (!level.isClientSide()) {
                this.setBlock(player, pos, Blocks.DIRT);
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
            }
            this.utils.sound.playSoundByBlock(player, pos, SoundEvents.HOE_TILL);
            return true;
        }
        return false;
    }

    @Override
    public boolean isTool() {
        return true;
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return !this.hasCriticalDamage(stack) && super.isCorrectToolForDrops(stack, state);
    }

    @Override
    public ModToolMaterial getMaterial() {
        return this.material;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.hasCriticalDamage(stack)) {
            return 1.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    @Override
    public IMaterialProperties getMaterialProperties() {
        return this.materialProperties;
    }

    private InteractionResult useOnBasic(UseOnContext context) {
        Pair pair;
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState toolModifiedState = level.getBlockState(blockpos = context.getClickedPos()).getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, ModHoe.changeIntoState(toolModifiedState));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player player = context.getPlayer();
            level.playSound((Entity)player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide()) {
                consumer.accept(context);
                if (player != null) {
                    EquipmentSlot slot = context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, slot);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static Consumer<UseOnContext> changeIntoState(BlockState state) {
        return context -> {
            context.getLevel().setBlock(context.getClickedPos(), state, 11);
            context.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, context.getClickedPos(), GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)state));
        };
    }
}

