/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.events.cleaners.Cleaner;
import com.pekar.angelblock.events.cleaners.TrackedBlock;
import com.pekar.angelblock.tools.IModTool;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tooltip.ITooltipProvider;
import com.pekar.angelblock.utils.Utils;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;

public abstract class ModSword
extends Item
implements IModTool {
    private static final int[] dx = new int[]{3, -3, 2, 2, -2, -2, 0, 0, 1, 1, -1, -1};
    private static final int[] dz = new int[]{0, 0, 1, -1, 1, -1, 3, -3, 2, -2, 2, -2};
    private static final int CactusLifeTime = 1200;
    private static final int WebLifeTime = 1200;
    private static final int TimeThreshold = 600;
    protected final Utils utils = new Utils();
    private final ModToolMaterial material;

    public ModSword(ModToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(material.getVanillaMaterial().applySwordProperties(properties, attackDamage, attackSpeed));
        this.material = material;
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public void setDamage(ItemStack stack, int damage) {
        int modifiedDamage = Mth.clamp((int)damage, (int)0, (int)(stack.getMaxDamage() - this.getCriticalDurability()));
        stack.set(DataComponents.DAMAGE, (Object)modifiedDamage);
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return !this.hasCriticalDamage(stack) && super.isCorrectToolForDrops(stack, state);
    }

    @Override
    public ModToolMaterial getMaterial() {
        return this.material;
    }

    @Override
    public String getMaterialName() {
        ModToolMaterial modToolMaterial = this.getMaterial();
        if (modToolMaterial instanceof ModToolMaterial) {
            ModToolMaterial toolMaterial = modToolMaterial;
            return toolMaterial.getName();
        }
        return "";
    }

    @Override
    public int getCriticalDurability() {
        return 3;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.hasCriticalDamage(stack)) {
            return 1.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return !this.hasCriticalDamage(stack) && super.canPerformAction(stack, itemAbility);
    }

    public void hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.hasCriticalDamage(stack)) {
            this.additionalActionOnHurtEnemy(stack, target, attacker);
        }
    }

    public void postHurtEnemy(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        itemStack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    protected void additionalActionOnHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
    }

    protected final void setEffectAround(Player player, InteractionHand interactionHand, Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        int posX = pos.getX();
        int posZ = pos.getZ();
        int posY = blockState.is(BlockTags.REPLACEABLE) ? (level.getBlockState(pos.below()).is(BlockTags.REPLACEABLE) ? pos.below(2).getY() : pos.below().getY()) : pos.getY();
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dz = -4; dz <= 4; ++dz) {
                if (Math.abs(dx) + Math.abs(dz) < 3) continue;
                BlockPos blockPos = new BlockPos(posX + dx, posY, posZ + dz);
                this.processBlock(player, interactionHand, level, blockPos);
            }
        }
        this.damageProperHandItemIfSurvivalIgnoreClient(player, interactionHand, level);
        this.causePlayerExhaustion(player);
    }

    protected final void setEffectAhead(Player player, InteractionHand interactionHand, Level level, BlockPos pos) {
        int b2;
        int k;
        int a2;
        BlockState blockState = level.getBlockState(pos);
        int posX = pos.getX();
        int posZ = pos.getZ();
        int posY = blockState.is(BlockTags.REPLACEABLE) ? (level.getBlockState(pos.below()).is(BlockTags.REPLACEABLE) ? pos.below(2).getY() : pos.below().getY()) : pos.getY();
        BlockPos playerPos = player.blockPosition();
        int playerPosX = playerPos.getX();
        int playerPosZ = playerPos.getZ();
        int effectLength = 9;
        int effectWidth = 4;
        int effectHalfWidth = 2;
        if (Math.abs(posX - playerPosX) < 2) {
            a1 = -2;
            a2 = 2;
            k = 0;
            n = 0;
            if (posZ > playerPosZ) {
                b1 = 0;
                b2 = 9;
            } else {
                b1 = -9;
                b2 = 0;
            }
        } else if (posX > playerPosX) {
            a1 = 0;
            a2 = 9;
            if (Math.abs(posZ - playerPosZ) < 2) {
                b1 = -2;
                b2 = 2;
                k = 0;
                n = 0;
            } else if (posZ > playerPosZ) {
                b1 = 0;
                b2 = 9;
                k = -1;
                n = 0;
            } else {
                b1 = -9;
                b2 = 0;
                k = 0;
                n = 1;
            }
        } else {
            a1 = -9;
            a2 = 0;
            if (Math.abs(posZ - playerPosZ) < 2) {
                b1 = -2;
                b2 = 2;
                k = 0;
                n = 0;
            } else if (posZ > playerPosZ) {
                b1 = 0;
                b2 = 9;
                n = 0;
                k = 1;
            } else {
                b1 = -9;
                b2 = 0;
                n = -1;
                k = 0;
            }
        }
        for (int dx = a1; dx <= a2; ++dx) {
            for (int dz = b1 + dx * n; dz <= b2 + dx * k; ++dz) {
                BlockPos blockPos = new BlockPos(posX + dx, posY, posZ + dz);
                this.processBlock(player, interactionHand, level, blockPos);
            }
        }
        this.damageProperHandItemIfSurvivalIgnoreClient(player, interactionHand, level);
        this.causePlayerExhaustion(player);
    }

    protected void processBlock(Player player, InteractionHand interactionHand, Level level, BlockPos pos) {
    }

    protected boolean allowsApplyEffect(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        if (level.isEmptyBlock(pos) || !blockState.isSolidRender()) {
            return false;
        }
        BlockPos posAbove = pos.above();
        if (level.isEmptyBlock(posAbove)) {
            return true;
        }
        BlockState blockStateAbove = level.getBlockState(posAbove);
        BlockState blockStateAbove2 = level.getBlockState(posAbove.above());
        return blockStateAbove.is(BlockTags.REPLACEABLE) && !blockStateAbove.is(Blocks.WATER) && !blockStateAbove.is(Blocks.LAVA) && !blockStateAbove2.is(Blocks.WATER) && !blockStateAbove2.is(Blocks.LAVA);
    }

    private BlockPos calculateCorrectYPosForPlacement(Level level, BlockPos pos) {
        if (this.allowsApplyEffect(level, pos)) {
            return pos;
        }
        if (this.allowsApplyEffect(level, pos.below())) {
            return pos.below();
        }
        if (this.allowsApplyEffect(level, pos.above())) {
            return pos.above();
        }
        return null;
    }

    protected final void trySetFire(Level level, BlockPos pos) {
        BlockPos correctPos = this.calculateCorrectYPosForPlacement(level, pos);
        if (correctPos == null) {
            return;
        }
        if (!level.isClientSide()) {
            level.setBlock(correctPos.above(), Blocks.FIRE.defaultBlockState(), 11);
        }
    }

    protected final void setWeb(Player player, Level level, BlockPos pos) {
        if (level.isClientSide()) {
            return;
        }
        BlockPos correctPos = this.calculateCorrectYPosForPlacement(level, pos.below());
        if (correctPos == null) {
            return;
        }
        level.setBlock(correctPos.above(), Blocks.COBWEB.defaultBlockState(), 11);
        int increment = Utils.random.nextInt(600);
        TrackedBlock targetToRemove = new TrackedBlock(Blocks.COBWEB, correctPos.above(), player, 1200 + increment, true);
        Cleaner.add(targetToRemove);
    }

    protected void explode(Player player, InteractionHand interactionHand, Level level, BlockPos pos) {
        level.explode((Entity)player, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), 0.8f, false, Level.ExplosionInteraction.NONE);
        level.explode((Entity)player, (double)pos.getX() + 0.8, (double)pos.getY() + 0.2, (double)pos.getZ() + 0.8, 0.8f, Level.ExplosionInteraction.NONE);
        level.explode((Entity)player, (double)pos.getX() + 0.8, (double)pos.getY() + 0.7, (double)pos.getZ() - 0.8, 0.8f, Level.ExplosionInteraction.NONE);
        level.explode((Entity)player, (double)pos.getX() - 0.8, (double)pos.getY() + 0.4, (double)pos.getZ() + 0.8, 0.8f, Level.ExplosionInteraction.NONE);
        level.explode((Entity)player, (double)pos.getX() - 0.8, (double)pos.getY() + 1.5, (double)pos.getZ() - 0.8, 0.8f, Level.ExplosionInteraction.NONE);
        this.damageProperHandItemIfSurvivalIgnoreClient(player, interactionHand, level);
        this.causePlayerExhaustion(player);
    }

    protected final void plantCacti(Player player, Level level, BlockPos pos, InteractionHand interactionHand, Direction facing) {
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        boolean succeeded = false;
        for (int i = 0; i < dx.length; ++i) {
            BlockPos blockPos = new BlockPos(posX + dx[i], posY, posZ + dz[i]);
            if (!this.tryPlantCactus(player, level, blockPos, interactionHand, facing)) continue;
            succeeded = true;
        }
        if (succeeded) {
            this.damageProperHandItemIfSurvivalIgnoreClient(player, interactionHand, level);
            this.causePlayerExhaustion(player);
        }
    }

    protected final boolean canUseToolEffect(Player player) {
        ItemStack mainHandItemStack = player.getMainHandItem();
        if (this.hasCriticalDamage(mainHandItemStack)) {
            return false;
        }
        ItemStack offHandItemStack = player.getOffhandItem();
        return offHandItemStack.isEmpty() || offHandItemStack.is(Items.TOTEM_OF_UNDYING);
    }

    private boolean tryPlantCactus(Player player, Level level, BlockPos pos, InteractionHand hand, Direction facing) {
        BlockState state = level.getBlockState(pos);
        if (!(state.is(BlockTags.SAND) && this.allowsApplyEffect(level, pos) && level.isEmptyBlock(pos.above(2)) && level.isEmptyBlock(pos.above(3)) && this.hasEnoughSpace(level, pos.above()))) {
            return false;
        }
        if (!this.plantCactus(player, level, pos, hand, facing)) {
            return false;
        }
        level.setBlock(pos.above(2), Blocks.CACTUS.defaultBlockState(), 11);
        level.setBlock(pos.above(3), Blocks.CACTUS.defaultBlockState(), 11);
        int increment = Utils.random.nextInt(600);
        TrackedBlock targetToRemove1 = new TrackedBlock(Blocks.CACTUS, pos.above(3), player, 1200 + increment, false);
        TrackedBlock targetToRemove2 = new TrackedBlock(Blocks.CACTUS, pos.above(2), player, 1200 + increment + 15, false);
        TrackedBlock targetToRemove3 = new TrackedBlock(Blocks.CACTUS, pos.above(), player, 1200 + increment + 30, false);
        Cleaner.add(targetToRemove1);
        Cleaner.add(targetToRemove2);
        Cleaner.add(targetToRemove3);
        return true;
    }

    private boolean hasEnoughSpace(Level level, BlockPos pos) {
        return level.isEmptyBlock(pos.east()) && level.isEmptyBlock(pos.west()) && level.isEmptyBlock(pos.north()) && level.isEmptyBlock(pos.south());
    }

    private boolean plantCactus(Player player, Level level, BlockPos pos, InteractionHand hand, Direction facing) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockState state = level.getBlockState(pos);
        if (facing == Direction.UP && this.allowsApplyEffect(level, pos) && !state.getBlock().canSustainPlant(state, (BlockGetter)level, pos, Direction.UP, Blocks.CACTUS.defaultBlockState()).isFalse()) {
            level.setBlock(pos.above(), Blocks.CACTUS.defaultBlockState(), 11);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, pos.above(), itemstack);
            }
            return true;
        }
        return false;
    }

    protected void damageProperHandItemIfSurvivalIgnoreClient(Player player, InteractionHand interactionHand, Level level) {
        if (interactionHand == InteractionHand.MAIN_HAND) {
            this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
        } else {
            this.damageOffHandItemIfSurvivalIgnoreClient(player, level);
        }
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    public boolean hasExplosionMode() {
        return false;
    }

    public boolean hasFireMode() {
        return false;
    }

    public boolean hasWebMode() {
        return false;
    }

    public final void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> component, TooltipFlag flag) {
        ITooltipProvider.appendHoverText(this, stack, context, display, component, flag);
    }
}

