/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.utils;

import com.pekar.angelblock.utils.PlayerConditions;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class Player {
    public final PlayerConditions conditions = new PlayerConditions();

    Player() {
    }

    public List<ItemStack> getArmorInSlots(LivingEntity entity) {
        return Arrays.asList(entity.getItemBySlot(EquipmentSlot.HEAD), entity.getItemBySlot(EquipmentSlot.CHEST), entity.getItemBySlot(EquipmentSlot.LEGS), entity.getItemBySlot(EquipmentSlot.FEET));
    }

    public List<EquipmentSlot> getArmorSlots() {
        return Arrays.asList(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
    }

    public Direction getDirection(LivingEntity entityLiving, BlockPos pos) {
        BlockPos entityPos = entityLiving.blockPosition();
        int entityX = entityPos.getX();
        int entityY = entityPos.getY();
        int entityZ = entityPos.getZ();
        if (pos.getY() > entityY + 2) {
            return Direction.UP;
        }
        if (entityY - pos.getY() > 1) {
            return Direction.DOWN;
        }
        if (pos.getY() < entityY && Math.abs(pos.getX() - entityX) < 2 && Math.abs(pos.getZ() - entityZ) < 2) {
            return Direction.DOWN;
        }
        return entityLiving.getDirection();
    }

    public Direction getDirectionForShovel(LivingEntity entityLiving, BlockPos pos) {
        BlockPos entityPos = entityLiving.blockPosition();
        int entityY = entityPos.getY();
        if (pos.getY() > entityY + 2) {
            return Direction.UP;
        }
        if (entityY >= pos.getY()) {
            return Direction.DOWN;
        }
        return entityLiving.getDirection();
    }

    public boolean destroyBlockByMainHandTool(Level level, BlockPos pos, LivingEntity entityLiving, BlockState blockState, Block block) {
        if (level.isClientSide()) {
            return false;
        }
        int recursionLeft = 512;
        return this.destroyBlock(pos, true, (Entity)entityLiving, level, entityLiving.getMainHandItem(), blockState, 512);
    }

    private boolean destroyBlock(BlockPos pos, boolean dropBlock, @NotNull Entity entity, Level level, ItemStack tool, BlockState blockState, int recursionLeft) {
        boolean flag;
        BlockEntity blockEntity;
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.isAir()) {
            return false;
        }
        FluidState fluidstate = level.getFluidState(pos);
        if (!(blockstate.getBlock() instanceof BaseFireBlock)) {
            level.levelEvent(2001, pos, Block.getId((BlockState)blockstate));
        }
        BlockEntity blockEntity2 = blockEntity = blockstate.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        if (dropBlock) {
            Block.dropResources((BlockState)blockstate, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)entity, (ItemStack)tool);
        }
        if (flag = level.setBlock(pos, fluidstate.createLegacyBlock(), 3, recursionLeft)) {
            int exp;
            MinecraftServer server;
            if (entity instanceof ServerPlayer && (server = level.getServer()) != null && !Player.hasSilkTouch(tool, (ServerLevel)level) && (exp = blockState.getExpDrop((LevelAccessor)level, pos, blockEntity, entity, tool)) > 0) {
                blockState.getBlock().popExperience((ServerLevel)level, pos, exp);
            }
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
        }
        return flag;
    }

    public static boolean hasSilkTouch(ItemStack stack, ServerLevel level) {
        return level.getServer().registryAccess().lookup(Registries.ENCHANTMENT).flatMap(lookup -> lookup.get(Enchantments.SILK_TOUCH)).map(holder -> stack.getEnchantmentLevel((Holder)holder) > 0).orElse(false);
    }
}

