/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.utils;

import com.pekar.angelblock.armor.ModArmor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class AttributeModifiers {
    public void updateArmorAttributeModifier(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        AttributeInstance armorAttribute = entity.getAttribute(Attributes.ARMOR);
        if (armorAttribute != null) {
            int damageSum = 0;
            int maxDamageSum = 0;
            for (ItemStack slot : entity.getArmorSlots()) {
                if (slot.isEmpty()) continue;
                boolean isModArmor = slot.getItem() instanceof ModArmor;
                damageSum += isModArmor ? slot.getDamageValue() : 0;
                maxDamageSum += slot.getMaxDamage();
            }
            int durabilitySum = maxDamageSum - damageSum;
            ResourceLocation armorModifierId = ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)this.getArmorAttributeMofifierId(entity));
            armorAttribute.removeModifier(armorModifierId);
            double durabilityPercent = (double)durabilitySum / (double)maxDamageSum;
            double correction = armorAttribute.getValue() * (durabilityPercent - 1.0);
            armorAttribute.addTransientModifier(new AttributeModifier(armorModifierId, correction, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    public void removeArmorAttributeModifier(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        AttributeInstance armorAttribute = entity.getAttribute(Attributes.ARMOR);
        if (armorAttribute != null) {
            ResourceLocation armorModifierId = ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)this.getArmorAttributeMofifierId(entity));
            armorAttribute.removeModifier(armorModifierId);
        }
    }

    private String getArmorAttributeMofifierId(LivingEntity entity) {
        return entity.getStringUUID();
    }
}

