/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.mixins;

import com.pekar.angelblock.Main;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    private void logArmorAbsorb(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        double armorValue = ((LivingEntity)this).getAttributeValue(Attributes.ARMOR);
        double toughness = ((LivingEntity)this).getAttributeValue(Attributes.ARMOR_TOUGHNESS);
        Main.LOGGER.error("ARMOR ABSORB - Incoming: " + amount + " | Armor: " + armorValue + " | Toughness: " + toughness);
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="RETURN")})
    private void logMagicReductionAfter(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        Main.LOGGER.error("MAGIC ABSORB (AFTER) - Final: " + String.valueOf(cir.getReturnValue()));
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void logLivingHurtBefore(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Main.LOGGER.error("LIVING HURT (BEFORE SUPER) - Incoming Damage: " + amount);
    }

    @Inject(method={"hurt"}, at={@At(value="TAIL")})
    private void logLivingHurtAfter(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Main.LOGGER.error("LIVING HURT (AFTER SUPER) - Damage: " + amount);
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")})
    private void trackLivingHurtAfter(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Main.LOGGER.error("LIVING HURT END - Damage: " + amount);
    }
}

