/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface IDamageable {
    default public boolean hasCriticalDamage(ItemStack stack) {
        return stack.getMaxDamage() - stack.getDamageValue() <= this.getCriticalDurability();
    }

    default public boolean hasLowEfficiencyDamage(ItemStack stack) {
        return stack.getMaxDamage() - stack.getDamageValue() <= this.getLowEfficiencyDurability(stack.getMaxDamage());
    }

    default public boolean hasExtraLowEfficiencyDamage(ItemStack stack) {
        return stack.getMaxDamage() - stack.getDamageValue() <= this.getExtraLowEfficiencyDurability(stack.getMaxDamage());
    }

    default public int getCriticalDurability() {
        return 2;
    }

    default public int getLowEfficiencyDurability(int maxDurability) {
        return maxDurability / 3;
    }

    default public int getExtraLowEfficiencyDurability(int maxDurability) {
        return maxDurability / 5;
    }

    default public void damageMainHandItem(int amount, LivingEntity livingEntity) {
        int modifiedAmount;
        ItemStack itemStack = livingEntity.getItemInHand(InteractionHand.MAIN_HAND);
        int durability = itemStack.getMaxDamage() - itemStack.getDamageValue();
        int n = modifiedAmount = durability > amount ? amount : durability - 1;
        if (itemStack.getItem().equals(this)) {
            itemStack.hurtAndBreak(modifiedAmount, livingEntity, EquipmentSlot.MAINHAND);
        }
    }

    default public void damageOffHandItem(int amount, LivingEntity livingEntity) {
        ItemStack itemStack = livingEntity.getItemInHand(InteractionHand.OFF_HAND);
        itemStack.hurtAndBreak(amount, livingEntity, EquipmentSlot.OFFHAND);
    }

    default public void damageMainHandItemIfSurvivalIgnoreClient(Player player, Level level) {
        ServerPlayer serverPlayer;
        if (level.isClientSide()) {
            return;
        }
        if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).isCreative()) {
            this.damageMainHandItem(1, (LivingEntity)player);
        }
    }

    default public void damageOffHandItemIfSurvivalIgnoreClient(Player player, Level level) {
        ServerPlayer serverPlayer;
        if (level.isClientSide()) {
            return;
        }
        if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).isCreative()) {
            this.damageOffHandItem(1, (LivingEntity)player);
        }
    }
}

