/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.AncientRod;
import com.pekar.angelblock.tools.DetectorFlags;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.ToolRegistry;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import com.pekar.angelblock.utils.SoundType;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class MarineRod
extends AncientRod {
    public MarineRod(ModToolMaterial material, boolean isMagnetic, Item.Properties properties) {
        super(material, isMagnetic, properties);
    }

    @Override
    protected InteractionResult useOnInternal(UseOnContext context) {
        InteractionResult result;
        Player player = context.getPlayer();
        Level level = player.level();
        if (this.isEnhanced() && player.hasEffect(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT)) {
            return super.useOnInternal(context);
        }
        BlockPos pos = context.getClickedPos();
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        ItemStack itemStack = player.getItemInHand(context.getHand());
        boolean isBroken = this.hasCriticalDamage(itemStack);
        InteractionHand hand = context.getHand();
        Direction facing = context.getClickedFace();
        Random itemRand = new Random();
        if (!isBroken) {
            BlockPos upPos;
            boolean isClientSide = level.isClientSide();
            if (facing == Direction.UP && (level.isWaterAt(upPos = pos.above()) && !level.getBlockState(upPos).getFluidState().isSource() || level.isEmptyBlock(upPos) && (this.utils.blocks.types.isFarmTypeBlock(level, upPos.north()) && this.utils.blocks.types.isFarmTypeBlock(level, upPos.south()) || this.utils.blocks.types.isFarmTypeBlock(level, upPos.east()) && this.utils.blocks.types.isFarmTypeBlock(level, upPos.west())))) {
                if (!isClientSide) {
                    level.setBlock(upPos, Blocks.WATER.defaultBlockState(), 11);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                this.utils.sound.playSoundByBlock(player, pos, SoundType.WATER_PLACED);
                return this.getToolInteractionResult(true, isClientSide);
            }
            if (block == Blocks.MELON) {
                if (!isClientSide) {
                    this.setBlock(player, pos, Blocks.SLIME_BLOCK);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
            if (block == Blocks.POWDER_SNOW) {
                if (!isClientSide) {
                    this.setBlock(player, pos, Blocks.SNOW_BLOCK);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
        }
        if ((result = super.useOnInternal(context)) != InteractionResult.PASS) {
            return result;
        }
        if (!isBroken && facing == Direction.UP) {
            if (block == Blocks.PODZOL || block == Blocks.MYCELIUM) {
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                int randomValue = itemRand.nextInt() & 1;
                Block plantBlock = randomValue == 0 ? Blocks.BROWN_MUSHROOM : Blocks.RED_MUSHROOM;
                return this.plant(player, level, pos, hand, facing, plantBlock);
            }
            if (block == Blocks.RED_SAND || block == Blocks.GRAVEL) {
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                return this.plant(player, level, pos, hand, facing, Blocks.BAMBOO);
            }
            if (block == Blocks.CLAY && this.utils.blocks.conditions.isNearWaterHorizontal(level, pos)) {
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                return this.plant(player, level, pos, hand, facing, Blocks.SMALL_DRIPLEAF);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void appendPlacingBlockInfo(ITooltip tooltip, boolean selectAsNew) {
        super.appendPlacingBlockInfo(tooltip, false);
        for (int i = 2; i <= 5; ++i) {
            tooltip.addLine(this.getRodDescriptionId(), i).withFormatting(ChatFormatting.WHITE, selectAsNew).apply();
        }
    }

    @Override
    protected void appendBlockTransformInfo(ITooltip tooltip, boolean selectAsNew) {
        super.appendBlockTransformInfo(tooltip, false);
        for (int i = 9; i <= 11; ++i) {
            tooltip.addLine(this.getRodDescriptionId(), i).withFormatting(ChatFormatting.WHITE, selectAsNew).apply();
        }
    }

    @Override
    protected void appendMagneticInfo(ITooltip tooltip) {
        for (int i = 13; i <= 21; ++i) {
            if (i == 21) {
                tooltip.addEmptyLine();
            }
            tooltip.addLine(this.getRodDescriptionId(), i).styledAs(TextStyle.Header, i == 13).styledAs(TextStyle.DarkGray, i == 21).apply();
        }
    }

    @Override
    protected void appendCommonPostInfo(ITooltip tooltip) {
        for (int i = 22; i <= 23; ++i) {
            tooltip.addLine(this.getRodDescriptionId(), i).styledAs(TextStyle.DarkGray, i == 22).apply();
        }
    }

    private String getRodId() {
        return ToolRegistry.MARINE_ROD.getRegisteredName();
    }

    private String getRodDescriptionId() {
        return this.formatDescriptionId(this.getRodId());
    }

    @Override
    protected int getOreDepth() {
        return 7;
    }

    @Override
    protected void oreFoundEvent(ServerPlayer player, BlockPos pos, DetectorFlags detectorFlags) {
        if (detectorFlags.isDiamondOreFound()) {
            this.utils.sound.playSoundOnBothSides(player, pos, SoundType.DIAMOND_FOUND, SoundSource.BLOCKS, 5.0f);
        } else if (detectorFlags.isAmethystFound()) {
            this.utils.sound.playSoundOnBothSides(player, pos, SoundType.AMETHYST_FOUND, SoundSource.BLOCKS, 5.0f);
        } else if (detectorFlags.isShiftingOreFound()) {
            this.utils.sound.playSoundOnBothSides(player, pos, SoundType.ORE_FOUND, SoundSource.BLOCKS, 5.0f);
        }
    }
}

