/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.WorkRod;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import com.pekar.angelblock.utils.SoundType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TrackLayer
extends WorkRod {
    public TrackLayer(ModToolMaterial material, Item.Properties properties) {
        super(material, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        int offHandItemCountAfterUse;
        InteractionResult result;
        Player player = context.getPlayer();
        Level level = player.level();
        ItemStack offHandItemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        int offHandItemCountBeforeUse = offHandItemStack.getCount();
        BlockPos pos = context.getClickedPos();
        Item offHandItem = offHandItemStack.getItem();
        boolean success = false;
        if (offHandItem instanceof BlockItem) {
            success = this.placeBlocks(player, level, pos, context.getClickedFace());
        }
        if (((result = this.getToolInteractionResult(success, level.isClientSide())) == InteractionResult.SUCCESS || result == InteractionResult.SUCCESS_SERVER) && (offHandItemCountAfterUse = offHandItemStack.getCount()) < offHandItemCountBeforeUse) {
            this.causePlayerExhaustion(player);
        }
        return result;
    }

    @Override
    public boolean mineBlock(ItemStack itemStack, Level level, BlockState blockState, BlockPos pos, LivingEntity livingEntity) {
        if (this.hasCriticalDamage(itemStack)) {
            return false;
        }
        if (!level.isClientSide() && this.isTrackLayerCompatible(blockState) && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.dropBlocks(player, level, pos);
            this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
        }
        return true;
    }

    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        if (this.hasCriticalDamage(itemStack)) {
            return 1.0f;
        }
        return this.isTrackLayerCompatible(blockState) ? 10.0f : 1.0f;
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.isTrackLayerCompatible(state);
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip, flag)) {
            return;
        }
        for (int i = 0; i <= 8; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1 || i == 3).styledAs(TextStyle.ImportantNotice, i == 5).styledAs(TextStyle.DarkGray, i == 7).apply();
        }
    }

    protected boolean dropBlocks(Player player, Level level, BlockPos pos) {
        int DROP_LENGTH = 8;
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        int shiftX = 1;
        int shiftZ = 1;
        int incX = 1;
        int incZ = 1;
        switch (player.getDirection()) {
            case NORTH: {
                shiftZ = -8;
                incZ = -1;
                break;
            }
            case SOUTH: {
                shiftZ = 8;
                break;
            }
            case EAST: {
                shiftX = 8;
                break;
            }
            case WEST: {
                shiftX = -8;
                incX = -1;
            }
        }
        boolean haveAnyDone = false;
        ItemStack toolItemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        Block originBlock = level.getBlockState(pos).getBlock();
        int y = posY;
        for (int x = posX; x != posX + shiftX; x += incX) {
            for (int z = posZ; z != posZ + shiftZ; z += incZ) {
                BlockPos updatedPos = this.checkNextPosToDrop(level, new BlockPos(x, y, z), originBlock);
                boolean hasDone = this.dropBlock(player, level, originBlock, new BlockPos(x, y = updatedPos.getY(), z), toolItemStack, true);
                if (!hasDone) continue;
                haveAnyDone = true;
            }
        }
        return haveAnyDone;
    }

    protected boolean placeBlocks(Player player, Level level, BlockPos pos, Direction facing) {
        if (facing != Direction.UP) {
            return false;
        }
        ItemStack offHandItemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        Item item = offHandItemStack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block placingBlock = blockItem.getBlock();
        if (!this.isTrackLayerCompatible(placingBlock.defaultBlockState())) {
            return false;
        }
        int MAX_PLACEMENT_LENGTH = 65;
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        int shiftX = 0;
        int shiftZ = 0;
        int increment = 0;
        switch (player.getDirection()) {
            case NORTH: {
                shiftX = -1;
                shiftZ = -65;
                increment = -1;
                break;
            }
            case SOUTH: {
                shiftX = 1;
                shiftZ = 65;
                increment = 1;
                break;
            }
            case EAST: {
                shiftX = 65;
                shiftZ = 1;
                increment = 1;
                break;
            }
            case WEST: {
                shiftX = -65;
                shiftZ = -1;
                increment = -1;
            }
        }
        boolean haveAnyPlaced = false;
        ItemStack toolItemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        Block originBlock = level.getBlockState(pos).getBlock();
        int y = this.utils.blocks.types.isRail(originBlock) ? posY - 1 : posY;
        for (int x = posX; x != posX + shiftX; x += increment) {
            for (int z = posZ; z != posZ + shiftZ; z += increment) {
                BlockPos updatedPos = this.checkPosToPlaceOn(level, new BlockPos(x, y, z), placingBlock);
                y = updatedPos.getY();
                boolean hasPlaced = this.placeBlock(player, level, originBlock, updatedPos, facing, toolItemStack, placingBlock);
                if (!hasPlaced) {
                    return haveAnyPlaced;
                }
                haveAnyPlaced = true;
            }
        }
        return haveAnyPlaced;
    }

    private BlockPos checkPosToPlaceOn(Level level, BlockPos originPos, Block placingBlock) {
        boolean areBothFenceOrWall;
        BlockState originBlockState = level.getBlockState(originPos);
        Block originBlock = originBlockState.getBlock();
        boolean areBothFence = originBlock instanceof FenceBlock && placingBlock instanceof FenceBlock;
        boolean areBothWall = originBlock instanceof WallBlock && placingBlock instanceof WallBlock;
        boolean bl = areBothFenceOrWall = areBothWall || areBothFence;
        if (areBothFenceOrWall) {
            return originPos;
        }
        if (this.areSimilar(originBlock, placingBlock)) {
            return originPos.below();
        }
        BlockPos upPos = originPos.above();
        boolean isUpperBlockSolid = this.isBlockSolidOrTransparent(level, upPos);
        if (isUpperBlockSolid) {
            BlockState theBlockStateAboveUpper = level.getBlockState(upPos.above());
            Block theBlockAboveUpper = theBlockStateAboveUpper.getBlock();
            boolean canGoUp = theBlockStateAboveUpper.isAir() || theBlockAboveUpper instanceof VegetationBlock || this.isAllowedReplaceWater(theBlockStateAboveUpper, placingBlock) || this.areSimilar(theBlockAboveUpper, placingBlock);
            return canGoUp ? upPos : originPos;
        }
        if (originBlockState.isAir() || originBlock instanceof VegetationBlock || this.isAllowedReplaceWater(originBlockState, placingBlock)) {
            BlockPos updatedPos = originPos.below();
            boolean isBlockBelowSolid = this.isBlockSolidOrTransparent(level, updatedPos);
            return isBlockBelowSolid ? updatedPos : originPos;
        }
        return originPos;
    }

    private BlockPos checkNextPosToDrop(Level level, BlockPos originPos, Block firstDroppedBlock) {
        BlockState blockState = level.getBlockState(originPos);
        Block block = blockState.getBlock();
        if (this.areSimilar(block, firstDroppedBlock)) {
            return originPos;
        }
        if (this.areSimilar(level.getBlockState(originPos.below()).getBlock(), firstDroppedBlock)) {
            return originPos.below();
        }
        if (this.areSimilar(level.getBlockState(originPos.above()).getBlock(), firstDroppedBlock)) {
            return originPos.above();
        }
        return originPos;
    }

    private boolean isTrackLayerCompatible(BlockState blockState) {
        return blockState.is(BlockRegistry.TRACK_LAYER_COMPATIBLE);
    }

    private boolean dropBlock(Player player, Level level, Block originBlock, BlockPos pos, ItemStack toolItemStack, boolean shouldDrop) {
        if (this.hasCriticalDamage(toolItemStack)) {
            return false;
        }
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        boolean canDrop = this.areSimilar(originBlock, block);
        if (!canDrop) {
            return false;
        }
        if (!level.isClientSide()) {
            level.destroyBlock(pos, shouldDrop);
            this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
        }
        return true;
    }

    private boolean placeBlock(Player player, Level level, Block originBlock, BlockPos pos, Direction facing, ItemStack toolItemStack, Block placingBlock) {
        boolean areBothFenceOrWall;
        if (this.hasCriticalDamage(toolItemStack)) {
            return false;
        }
        ItemStack offHandItemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        int itemCount = offHandItemStack.getCount();
        if (itemCount < 1) {
            return false;
        }
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        boolean areBothFence = block instanceof FenceBlock && placingBlock instanceof FenceBlock;
        boolean areBothWall = block instanceof WallBlock && placingBlock instanceof WallBlock;
        boolean bl = areBothFenceOrWall = areBothWall || areBothFence;
        if (!areBothFenceOrWall && this.areSimilar(placingBlock, block)) {
            return true;
        }
        boolean isBlockSolid = this.isBlockSolidOrTransparent(level, pos);
        if (block instanceof LiquidBlock || blockState.isAir() || !isBlockSolid && !areBothFenceOrWall) {
            return false;
        }
        BlockPos upPos = pos.above();
        BlockState upperBlockState = level.getBlockState(upPos);
        Block upperBlock = upperBlockState.getBlock();
        boolean isUpperBlockVegetation = upperBlock instanceof VegetationBlock;
        boolean canSkip = upperBlock != Blocks.REDSTONE_WIRE && this.areSimilar(placingBlock, upperBlock);
        boolean isUpperWaterReplacingByRails = this.isAllowedReplaceWater(upperBlockState, placingBlock);
        if (canSkip) {
            return true;
        }
        if (!(upperBlockState.isAir() || isUpperWaterReplacingByRails || isUpperBlockVegetation)) {
            return false;
        }
        if (!level.isClientSide()) {
            if (isUpperBlockVegetation) {
                level.destroyBlock(upPos, false);
            }
            level.setBlock(upPos, placingBlock.defaultBlockState(), 11);
            this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
            if (!player.isCreative()) {
                offHandItemStack.setCount(itemCount - 1);
            }
        }
        SoundType soundType = this.getSoundType(placingBlock);
        this.utils.sound.playSoundByBlock(player, upPos, soundType);
        return true;
    }

    private boolean areSimilar(Block block1, Block block2) {
        return block1 == block2 || block1 instanceof BaseRailBlock && block2 instanceof BaseRailBlock || block1 instanceof FenceBlock && block2 instanceof FenceBlock || block1 instanceof WallBlock && block2 instanceof WallBlock;
    }

    private boolean isAllowedReplaceWater(BlockState replacingBlockState, Block placingBlock) {
        return replacingBlockState.getBlock() == Blocks.WATER && this.utils.blocks.types.isRail(placingBlock);
    }

    private boolean isBlockSolidOrTransparent(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        return blockState.isSolidRender() || block instanceof TransparentBlock;
    }

    @NotNull
    private SoundType getSoundType(Block placingBlock) {
        SoundType soundType = SoundType.UNDEFINED;
        soundType = this.utils.blocks.types.isRail(placingBlock) ? SoundType.RAIL_PLACED : (placingBlock instanceof FenceBlock ? SoundType.WOOD_PLACED : (placingBlock instanceof WallBlock ? SoundType.STONE_PLACED : SoundType.REDSTONE_WIRE_PLACED));
        return soundType;
    }
}

