/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.armor;

import com.pekar.angelblock.armor.ArmorRegistry;
import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.armor.ModArmorMaterial;
import com.pekar.angelblock.armor.SuperArmor;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SuperArmorFlying
extends SuperArmor {
    protected SuperArmorFlying(ModArmorMaterial material, ArmorItem.Type equipmentSlot) {
        super(material, equipmentSlot);
        this.withElytra();
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        if (this.type != ArmorItem.Type.CHESTPLATE) {
            return false;
        }
        if (entity.hasEffect(MobEffects.SLOW_FALLING)) {
            return false;
        }
        boolean isFlyingChestplate = this.getModelName(entity, EquipmentSlot.CHEST).equals(((ModArmor)ArmorRegistry.SUPER_CHESTPLATE_FLYING.get()).getArmorFamilyName());
        int maxDamageToFly = stack.getMaxDamage() / 2;
        int chestDamage = stack.getDamageValue();
        return isFlyingChestplate && chestDamage < maxDamageToFly;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return this.canElytraFly(stack, entity);
    }

    private String getModelName(LivingEntity entity, EquipmentSlot slot) {
        Item item = entity.getItemBySlot(slot).getItem();
        if (!(item instanceof ModArmor)) {
            return "";
        }
        ModArmor armorItem = (ModArmor)item;
        return armorItem.getArmorFamilyName();
    }
}

