/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.blocks;

import com.pekar.angelblock.blocks.ModBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetherBarsBlock
extends ModBlock {
    private static final VoxelShape HITBOX_WEST_EAST = Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625);
    private static final VoxelShape HITBOX_NORTH_SOUTH = Shapes.box((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)1.0);
    private static final VoxelShape HITBOX_COLUMN = Shapes.box((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625);
    private static final VoxelShape HITBOX_CORNER_EAST_NORTH = Shapes.or((VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)0.5625));
    private static final VoxelShape HITBOX_CORNER_EAST_SOUTH = Shapes.or((VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)1.0), (VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625));
    private static final VoxelShape HITBOX_CORNER_WEST_NORTH = Shapes.or((VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)0.5625), (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625));
    private static final VoxelShape HITBOX_CORNER_WEST_SOUTH = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)1.0));
    private static final VoxelShape HITBOX_CROSS = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)1.0));
    private static final VoxelShape HITBOX_T_EAST = Shapes.or((VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)1.0));
    private static final VoxelShape HITBOX_T_WEST = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)1.0));
    private static final VoxelShape HITBOX_T_SOUTH = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)1.0));
    private static final VoxelShape HITBOX_T_NORTH = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (VoxelShape)Shapes.box((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)0.5625));
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;

    public NetherBarsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean north = (Boolean)state.getValue((Property)NORTH);
        boolean south = (Boolean)state.getValue((Property)SOUTH);
        boolean west = (Boolean)state.getValue((Property)WEST);
        boolean east = (Boolean)state.getValue((Property)EAST);
        if (north && south && west && east) {
            return HITBOX_CROSS;
        }
        if (north && south && west) {
            return HITBOX_T_WEST;
        }
        if (north && south && east) {
            return HITBOX_T_EAST;
        }
        if (west && east && north) {
            return HITBOX_T_NORTH;
        }
        if (west && east && south) {
            return HITBOX_T_SOUTH;
        }
        if (west && north) {
            return HITBOX_CORNER_WEST_NORTH;
        }
        if (west && south) {
            return HITBOX_CORNER_WEST_SOUTH;
        }
        if (east && north) {
            return HITBOX_CORNER_EAST_NORTH;
        }
        if (east && south) {
            return HITBOX_CORNER_EAST_SOUTH;
        }
        if (north || south) {
            return HITBOX_NORTH_SOUTH;
        }
        if (west || east) {
            return HITBOX_WEST_EAST;
        }
        return HITBOX_COLUMN;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, SOUTH, WEST, EAST});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        boolean north = this.connectsTo(level.getBlockState(pos.north()), (LevelAccessor)level, pos);
        boolean south = this.connectsTo(level.getBlockState(pos.south()), (LevelAccessor)level, pos);
        boolean west = this.connectsTo(level.getBlockState(pos.west()), (LevelAccessor)level, pos);
        boolean east = this.connectsTo(level.getBlockState(pos.east()), (LevelAccessor)level, pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        boolean north = this.connectsTo(level.getBlockState(pos.north()), level, pos);
        boolean south = this.connectsTo(level.getBlockState(pos.south()), level, pos);
        boolean west = this.connectsTo(level.getBlockState(pos.west()), level, pos);
        boolean east = this.connectsTo(level.getBlockState(pos.east()), level, pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east));
    }

    private boolean connectsTo(BlockState state, LevelAccessor level, BlockPos pos) {
        return state.getBlock() instanceof NetherBarsBlock || state.isSolidRender((BlockGetter)level, pos);
    }
}

