/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.cleaners;

import com.pekar.angelblock.events.cleaners.TrackedAllay;
import com.pekar.angelblock.events.cleaners.TrackedAllayData;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class TrackedAllaysData
extends SavedData {
    private final HashSet<TrackedAllayData> saved;
    public static final SavedData.Factory<TrackedAllaysData> TYPE = new SavedData.Factory(TrackedAllaysData::new, (compound, provider) -> {
        ListTag list = compound.getList("Tracked", 10);
        HashSet<TrackedAllayData> loaded = new HashSet<TrackedAllayData>();
        for (Tag tag : list) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag entry = (CompoundTag)tag;
            loaded.add(TrackedAllayData.load(entry));
        }
        return new TrackedAllaysData(loaded);
    }, null);

    public TrackedAllaysData(HashSet<TrackedAllayData> saved) {
        this.saved = saved;
    }

    public TrackedAllaysData() {
        this.saved = new HashSet();
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (TrackedAllayData data : this.saved) {
            list.add((Object)data.save());
        }
        tag.put("Tracked", (Tag)list);
        return tag;
    }

    public void store(TrackedAllay allay) {
        this.saved.add(new TrackedAllayData(((Allay)allay.getTargetInstance()).getUUID(), allay.getOwner().getUUID()));
        this.setDirty();
    }

    public void remove(TrackedAllay allay) {
        TrackedAllayData allayData = new TrackedAllayData(((Allay)allay.getTargetInstance()).getUUID(), allay.getOwner().getUUID());
        this.remove(allayData);
    }

    private void remove(TrackedAllayData data) {
        if (!this.saved.contains(data)) {
            return;
        }
        this.saved.remove(data);
        this.setDirty();
    }

    public Set<TrackedAllayData> getSaved() {
        return this.saved;
    }

    public static TrackedAllaysData get(ServerLevel level) {
        return (TrackedAllaysData)level.getDataStorage().computeIfAbsent(TYPE, "tracked_allays");
    }

    public static Set<TrackedAllay> restoreAllays(ServerPlayer player, TrackedAllaysData data) {
        HashSet<TrackedAllay> result = new HashSet<TrackedAllay>();
        ServerLevel level = (ServerLevel)player.level();
        for (TrackedAllayData dto : data.getSaved()) {
            Player owner;
            if (!player.getUUID().equals(dto.ownerUuid()) || (owner = level.getPlayerByUUID(dto.ownerUuid())) == null) continue;
            Entity entity = level.getEntity(dto.allayUuid());
            if (!(entity instanceof Allay)) {
                TrackedAllaysData.get(level).remove(dto);
                continue;
            }
            Allay allay = (Allay)entity;
            TrackedAllay tracked = new TrackedAllay(allay, owner);
            result.add(tracked);
        }
        return result;
    }
}

