/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.items;

import com.pekar.angelblock.items.ModItemWithMultipleHoverText;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SoaringSporeEssence
extends ModItemWithMultipleHoverText {
    public SoaringSporeEssence() {
        super(new Item.Properties().stacksTo(4));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand usedHand) {
        Level level = player.level();
        boolean isClientSide = level.isClientSide();
        if (entity instanceof Player) {
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!entity.hasEffect(MobEffects.GLOWING) || !entity.hasEffect(MobEffects.SLOW_FALLING)) {
                entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, -1, 0, true, true));
                entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, -1, 0, true, true));
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
            }
        }
        this.utils.sound.playSoundByLivingEntity(player, entity, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.sidedSuccess((boolean)isClientSide);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!this.utils.text.showExtendedDescription(tooltipComponents)) {
            return;
        }
        for (int i = 1; i <= 4; ++i) {
            MutableComponent component = this.getDescription(i, false);
            tooltipComponents.add((Component)component);
        }
    }
}

