/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.mixins;

import com.pekar.angelblock.armor.ArmorRegistry;
import com.pekar.angelblock.armor.ModArmor;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Axolotl.class})
public abstract class AxolotlMixin
extends Animal {
    private static final int BREEDING_INFLUENCE_RADIUS = 8;

    protected AxolotlMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Inject(method={"getBreedOffspring"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectBreedOffspring(ServerLevel level, AgeableMob partner, CallbackInfoReturnable<AgeableMob> cir) {
        Axolotl axolotl = (Axolotl)this;
        Axolotl offspring = (Axolotl)EntityType.AXOLOTL.create((Level)level);
        if (offspring != null) {
            boolean useRare = this.axolotlUseRareVariant(level, partner);
            Axolotl.Variant variant = useRare ? Axolotl.Variant.getRareSpawnVariant((RandomSource)axolotl.getRandom()) : (axolotl.getRandom().nextBoolean() ? axolotl.getVariant() : ((Axolotl)partner).getVariant());
            offspring.setVariant(variant);
            offspring.setPersistenceRequired();
        }
        cir.setReturnValue((Object)offspring);
    }

    private boolean axolotlUseRareVariant(ServerLevel level, AgeableMob partner) {
        RandomSource random = this.getRandom();
        List entities = level.getEntitiesOfClass(LivingEntity.class, partner.getBoundingBox().inflate(8.0));
        for (LivingEntity entity : entities) {
            if (!this.isWearingSpecialArmor(entity)) continue;
            return random.nextInt(100) == 0;
        }
        return random.nextInt(1200) == 0;
    }

    private boolean isWearingSpecialArmor(LivingEntity player) {
        for (ItemStack armor : player.getArmorSlots()) {
            if (armor.isEmpty()) {
                return false;
            }
            Item item = armor.getItem();
            if (!(item instanceof ModArmor)) {
                return false;
            }
            ModArmor modArmor = (ModArmor)item;
            if (modArmor.getArmorFamilyName().equals(((ModArmor)ArmorRegistry.LAPIS_BOOTS.get()).getArmorFamilyName())) continue;
            return false;
        }
        return true;
    }
}

