/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.recipe;

import com.pekar.angelblock.items.ItemRegistry;
import com.pekar.angelblock.recipe.AwkwardSplashPotionIngredient;
import com.pekar.angelblock.recipe.SlowFallingPotionIngredient;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

@EventBusSubscriber(modid="angelblock")
public class RecipeRegistry {
    private static final Ingredient AWKWARD_SPLASH_POTION = new Ingredient((ICustomIngredient)new AwkwardSplashPotionIngredient());
    private static final Ingredient SLOW_FALLING_POTION = new Ingredient((ICustomIngredient)new SlowFallingPotionIngredient());

    public static void initStatic() {
    }

    @SubscribeEvent
    public static void onRegisterBrewingRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        RecipeRegistry.registerBlockBreakerBrewing(builder);
        RecipeRegistry.registerSoaringSporeEssence(builder);
    }

    private static void registerBlockBreakerBrewing(PotionBrewing.Builder builder) {
        ItemStack output = new ItemStack((ItemLike)ItemRegistry.BLOCK_BREAKER_POTION_ITEM.get());
        BrewingRecipe recipe = new BrewingRecipe(AWKWARD_SPLASH_POTION, Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_SHARD}), output);
        builder.addRecipe((IBrewingRecipe)recipe);
    }

    private static void registerSoaringSporeEssence(PotionBrewing.Builder builder) {
        ItemStack output = new ItemStack((ItemLike)ItemRegistry.SOARING_SPORE_ESSENCE.get());
        TagKey froglightsTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"froglights"));
        BrewingRecipe recipe = new BrewingRecipe(SLOW_FALLING_POTION, Ingredient.of((TagKey)froglightsTag), output);
        builder.addRecipe((IBrewingRecipe)recipe);
    }
}

