/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.tools.IModDescriptionItem;
import com.pekar.angelblock.tools.IToolService;
import com.pekar.angelblock.tools.ModToolMaterial;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface IModTool
extends IModDescriptionItem,
IToolService {
    default public boolean hasCriticalDamage(ItemStack stack) {
        return stack.getMaxDamage() - stack.getDamageValue() <= this.getCriticalDurability();
    }

    default public int getCriticalDurability() {
        return 2;
    }

    default public boolean hasLowEfficiencyDurability(ItemStack stack) {
        return stack.getMaxDamage() - stack.getDamageValue() <= this.getLowEfficiencyDurability(stack.getMaxDamage());
    }

    default public boolean hasExtraLowEfficiencyDurability(ItemStack stack) {
        return stack.getMaxDamage() - stack.getDamageValue() <= this.getExtraLowEfficiencyDurability(stack.getMaxDamage());
    }

    default public int getLowEfficiencyDurability(int maxDurability) {
        return maxDurability / 3;
    }

    default public int getExtraLowEfficiencyDurability(int maxDurability) {
        return maxDurability / 5;
    }

    default public boolean isTool() {
        return false;
    }

    default public boolean isWeapon() {
        return false;
    }

    default public boolean isRod() {
        return false;
    }

    default public boolean isEnhanced() {
        return false;
    }

    public TieredItem getTool();

    default public String getMaterialName() {
        Tier tier = this.getTool().getTier();
        if (tier instanceof ModToolMaterial) {
            ModToolMaterial toolMaterial = (ModToolMaterial)tier;
            return toolMaterial.getName();
        }
        return "";
    }

    default public void damageMainHandItem(int amount, LivingEntity livingEntity) {
        int modifiedAmount;
        ItemStack itemStack = livingEntity.getItemInHand(InteractionHand.MAIN_HAND);
        int durability = itemStack.getMaxDamage() - itemStack.getDamageValue();
        int n = modifiedAmount = durability > amount ? amount : durability - 1;
        if (itemStack.getItem().equals(this)) {
            itemStack.hurtAndBreak(modifiedAmount, livingEntity, EquipmentSlot.MAINHAND);
        }
    }

    default public void damageOffHandItem(int amount, LivingEntity livingEntity) {
        ItemStack itemStack = livingEntity.getItemInHand(InteractionHand.OFF_HAND);
        itemStack.hurtAndBreak(amount, livingEntity, EquipmentSlot.OFFHAND);
    }

    default public void damageMainHandItemIfSurvivalIgnoreClient(Player player, Level level) {
        ServerPlayer serverPlayer;
        if (level.isClientSide()) {
            return;
        }
        if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).isCreative()) {
            this.damageMainHandItem(1, (LivingEntity)player);
        }
    }

    default public void damageOffHandItemIfSurvivalIgnoreClient(Player player, Level level) {
        ServerPlayer serverPlayer;
        if (level.isClientSide()) {
            return;
        }
        if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).isCreative()) {
            this.damageOffHandItem(1, (LivingEntity)player);
        }
    }

    default public boolean isToolEffective(LivingEntity entityLiving, BlockPos pos) {
        BlockState blockState = entityLiving.level().getBlockState(pos);
        return this.getTool().isCorrectToolForDrops(entityLiving.getMainHandItem(), blockState);
    }

    @Override
    default public MutableComponent getDisplayName(int lineNumber) {
        return Component.translatable((String)(this.getTool().getDescriptionId() + ".desc" + lineNumber));
    }
}

