/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.tools.IModToolEnhanceable;
import com.pekar.angelblock.tools.properties.DefaultMaterialProperties;
import com.pekar.angelblock.tools.properties.IMaterialProperties;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.ITooltipProvider;
import com.pekar.angelblock.tooltip.TextStyle;
import com.pekar.angelblock.utils.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbility;

public class ModShovel
extends ShovelItem
implements IModToolEnhanceable,
ITooltipProvider {
    protected final IMaterialProperties materialProperties;
    protected final Utils utils = new Utils();

    public static ModShovel createPrimary(Tier material, float attackDamage, float attackSpeed, Item.Properties properties) {
        return new ModShovel(material, attackDamage, attackSpeed, properties, new DefaultMaterialProperties());
    }

    public ModShovel(Tier material, float attackDamage, float attackSpeed, Item.Properties properties, IMaterialProperties materialProperties) {
        super(material, properties.attributes(ShovelItem.createAttributes((Tier)material, (float)attackDamage, (float)attackSpeed)));
        this.materialProperties = materialProperties;
        FLATTENABLES.put(Blocks.FARMLAND, Blocks.DIRT_PATH.defaultBlockState());
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Player player = context.getPlayer();
        Level level = player.level();
        BlockState blockState = level.getBlockState(pos = context.getClickedPos());
        Block block = blockState.getBlock();
        if (FLATTENABLES.containsKey(block) || block instanceof CampfireBlock && ((Boolean)blockState.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            return super.useOn(context);
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean isTool() {
        return true;
    }

    @Override
    public final TieredItem getTool() {
        return this;
    }

    public void setDamage(ItemStack stack, int damage) {
        int modifiedDamage = Mth.clamp((int)damage, (int)0, (int)(stack.getMaxDamage() - this.getCriticalDurability()));
        stack.set(DataComponents.DAMAGE, (Object)modifiedDamage);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return !this.hasCriticalDamage(stack) && super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.hasCriticalDamage(stack)) {
            return 1.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return !this.hasCriticalDamage(stack) && super.canPerformAction(stack, itemAbility);
    }

    public final void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ITooltipProvider.appendHoverText(this, stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    public final IMaterialProperties getMaterialProperties() {
        return this.materialProperties;
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        for (int i = 0; i <= 3; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.DarkGray, i == 2).apply();
        }
    }
}

