/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.utils;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.utils.BlockUtils;
import com.pekar.angelblock.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTypes {
    BlockTypes() {
    }

    public boolean isInfested(Block block) {
        return block instanceof InfestedBlock;
    }

    public boolean isSuspicious(Block block) {
        return block instanceof BrushableBlock;
    }

    public boolean holdsSuspiciousOrLiquid(LivingEntity livingEntity, BlockPos pos, boolean checkForWaterAndSuspicious, boolean checkForLava) {
        BlockPos posToCheck = pos;
        Level level = livingEntity.level();
        for (int i = 0; i < 16; ++i) {
            BlockState blockState = level.getBlockState(posToCheck);
            if (blockState.isAir()) {
                return false;
            }
            if (checkForWaterAndSuspicious && blockState.is(Blocks.WATER) && !livingEntity.isInWater()) {
                return true;
            }
            if (checkForLava && blockState.is(Blocks.LAVA) && !livingEntity.isInLava()) {
                return true;
            }
            Block block = blockState.getBlock();
            if (checkForWaterAndSuspicious && this.isSuspicious(block)) {
                return true;
            }
            boolean isFallingBlock = block instanceof FallingBlock;
            if (isFallingBlock) {
                BlockUtils blockUtils = Utils.instance.blocks;
                if (checkForWaterAndSuspicious && blockUtils.conditions.isNearWater(level, posToCheck) && !livingEntity.isInWater()) {
                    return true;
                }
                if (checkForLava && blockUtils.conditions.isNearLava(level, posToCheck) && !livingEntity.isInLava()) {
                    return true;
                }
            } else if (posToCheck.getY() > pos.getY() && blockState.isSolidRender((BlockGetter)level, posToCheck)) {
                return false;
            }
            posToCheck = posToCheck.above();
        }
        return false;
    }

    public boolean isOre(BlockState blockState) {
        TagKey ores = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)"ores"));
        return blockState.is(ores);
    }

    public boolean isLiquid(Block block) {
        return block instanceof LiquidBlock;
    }

    public boolean isCactiPlantableOn(BlockState blockState) {
        return blockState.is(BlockTags.SAND);
    }

    public boolean isGlassBlock(Block block) {
        return block == Blocks.GLASS || block == Blocks.TINTED_GLASS || block instanceof StainedGlassBlock;
    }

    public boolean isSandBlock(Block block) {
        return block == Blocks.SAND || block == Blocks.RED_SAND;
    }

    public boolean isFarmTypeBlock(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        return blockState.is(Blocks.GRASS_BLOCK) || blockState.is(BlockTags.DIRT) || blockState.is(Blocks.FARMLAND) || blockState.is(BlockTags.SAND) || blockState.is(Blocks.GRAVEL) || blockState.is(Blocks.SUSPICIOUS_GRAVEL);
    }

    public boolean isRail(Block block) {
        return block instanceof BaseRailBlock;
    }

    public boolean isDiamondOre(Block block) {
        return block == Blocks.DIAMOND_ORE || block == Blocks.DEEPSLATE_DIAMOND_ORE || block == BlockRegistry.GREEN_DIAMOND_ORE.get();
    }

    public boolean isSculk(Block block) {
        return block == Blocks.SCULK || block == Blocks.SCULK_VEIN || block == Blocks.SCULK_CATALYST || block == Blocks.SCULK_SENSOR || block == Blocks.SCULK_SHRIEKER;
    }

    public boolean canBeFarmland(Block block) {
        return block == Blocks.GRASS_BLOCK || block == Blocks.DIRT_PATH || block == Blocks.DIRT;
    }

    public Block getDestroyingWoolBlock(Block block) {
        if (block == Blocks.WHITE_WOOL) {
            return (Block)BlockRegistry.DESTROYING_WHITE_WOOL_BY_ROD.get();
        }
        if (block == Blocks.ORANGE_WOOL) {
            return (Block)BlockRegistry.DESTROYING_ORANGE_WOOL.get();
        }
        if (block == Blocks.MAGENTA_WOOL) {
            return (Block)BlockRegistry.DESTROYING_MAGENTA_WOOL.get();
        }
        if (block == Blocks.LIGHT_BLUE_WOOL) {
            return (Block)BlockRegistry.DESTROYING_LIGHT_BLUE_WOOL.get();
        }
        if (block == Blocks.YELLOW_WOOL) {
            return (Block)BlockRegistry.DESTROYING_YELLOW_WOOL.get();
        }
        if (block == Blocks.LIME_WOOL) {
            return (Block)BlockRegistry.DESTROYING_LIME_WOOL.get();
        }
        if (block == Blocks.PINK_WOOL) {
            return (Block)BlockRegistry.DESTROYING_PINK_WOOL.get();
        }
        if (block == Blocks.GRAY_WOOL) {
            return (Block)BlockRegistry.DESTROYING_GRAY_WOOL.get();
        }
        if (block == Blocks.LIGHT_GRAY_WOOL) {
            return (Block)BlockRegistry.DESTROYING_LIGHT_GRAY_WOOL.get();
        }
        if (block == Blocks.CYAN_WOOL) {
            return (Block)BlockRegistry.DESTROYING_CYAN_WOOL.get();
        }
        if (block == Blocks.PURPLE_WOOL) {
            return (Block)BlockRegistry.DESTROYING_PURPLE_WOOL.get();
        }
        if (block == Blocks.BLUE_WOOL) {
            return (Block)BlockRegistry.DESTROYING_BLUE_WOOL.get();
        }
        if (block == Blocks.BROWN_WOOL) {
            return (Block)BlockRegistry.DESTROYING_BROWN_WOOL.get();
        }
        if (block == Blocks.GREEN_WOOL) {
            return (Block)BlockRegistry.DESTROYING_GREEN_WOOL.get();
        }
        if (block == Blocks.RED_WOOL) {
            return (Block)BlockRegistry.DESTROYING_RED_WOOL.get();
        }
        if (block == Blocks.BLACK_WOOL) {
            return (Block)BlockRegistry.DESTROYING_BLACK_WOOL.get();
        }
        return null;
    }
}

