/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.network.packets;

import com.pekar.angelblock.events.PlayerManager;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.network.ClientToServerPacket;
import com.pekar.angelblock.network.Packet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ClientTickPacket
extends ClientToServerPacket {
    @Override
    public void onReceive(ServerPlayer serverPlayer) {
        IPlayer player = PlayerManager.instance().getPlayerByUUID(serverPlayer.getUUID());
        Player playerEntity = player.getEntity();
        for (IArmor armor : player.getArmorTypesUsed()) {
            armor.onCreeperCheck();
            if (playerEntity.isInWater()) {
                armor.onBeingInWater();
                continue;
            }
            if (playerEntity.isInWaterOrRain()) {
                armor.onBeingUnderRain();
                continue;
            }
            if (!playerEntity.isInLava()) continue;
            armor.onBeingInLava();
        }
    }

    @Override
    public String getPacketId() {
        return "client_tick";
    }

    @Override
    public Packet decode(FriendlyByteBuf buffer) {
        return new ClientTickPacket();
    }
}

