/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.potions;

import com.pekar.angelblock.Main;
import com.pekar.angelblock.potions.BlockBreakerPotion;
import com.pekar.angelblock.potions.CooldownEffect;
import com.pekar.angelblock.potions.HeavyJumpEffect;
import com.pekar.angelblock.potions.RodMagneticModeEffect;
import com.pekar.angelblock.potions.SuperJumpModeEffect;
import com.pekar.angelblock.potions.SwordExplosionModeMobEffect;
import com.pekar.angelblock.potions.SwordFireModeMobEffect;
import com.pekar.angelblock.potions.SwordWebModeMobEffect;
import com.pekar.angelblock.potions.ToolAdvancedModeMobEffect;
import com.pekar.angelblock.utils.Utils;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.neoforge.registries.DeferredHolder;

public class PotionRegistry {
    public static final Holder<MobEffect> SWORD_FIRE_MODE_EFFECT = PotionRegistry.registerMobEffect("sword_fire_mode_effect", SwordFireModeMobEffect::new);
    public static final Holder<MobEffect> SWORD_EXPLOSION_MODE_EFFECT = PotionRegistry.registerMobEffect("sword_explosion_mode_effect", SwordExplosionModeMobEffect::new);
    public static final Holder<MobEffect> SWORD_WEB_MODE_EFFECT = PotionRegistry.registerMobEffect("sword_web_mode_effect", SwordWebModeMobEffect::new);
    public static final Holder<MobEffect> TOOL_ADVANCED_MODE_EFFECT = PotionRegistry.registerMobEffect("tool_advanced_mode_effect", ToolAdvancedModeMobEffect::new);
    public static final Holder<MobEffect> ROD_MAGNETIC_MODE_EFFECT = PotionRegistry.registerMobEffect("rod_magnetic_mode_effect", RodMagneticModeEffect::new);
    public static final Holder<MobEffect> ARMOR_SUPER_JUMP_MODE_EFFECT = PotionRegistry.registerMobEffect("armor_super_jump_mode_effect", SuperJumpModeEffect::new);
    public static final Holder<MobEffect> ARMOR_HEAVY_JUMP_EFFECT = PotionRegistry.registerMobEffect("armor_heavy_jump_effect", HeavyJumpEffect::new);
    public static final Holder<MobEffect> BIOS_DIAMOND_COOLDOWN_EFFECT = PotionRegistry.registerMobEffect("bios_diamond_cooldown_effect", CooldownEffect::new);
    public static final Holder<MobEffect> END_SAPPHIRE_COOLDOWN_EFFECT = PotionRegistry.registerMobEffect("end_sapphire_cooldown_effect", CooldownEffect::new);
    public static final DeferredHolder<EntityType<?>, EntityType<BlockBreakerPotion>> BLOCK_BREAKER_POTION = PotionRegistry.registerThrownPotion("block_breaker_potion", (EntityType.EntityFactory<BlockBreakerPotion>)((EntityType.EntityFactory)BlockBreakerPotion::new));

    public static void initStatic() {
    }

    private static Holder<Potion> registerPotion(String name, Supplier<Potion> potion) {
        return Main.POTIONS.register(name, potion);
    }

    private static Holder<MobEffect> registerMobEffect(String name, Supplier<MobEffect> mobEffect) {
        return Main.MOB_EFFECTS.register(name, mobEffect);
    }

    private static DeferredHolder<EntityType<?>, EntityType<BlockBreakerPotion>> registerThrownPotion(String name, EntityType.EntityFactory<BlockBreakerPotion> potionFactory) {
        ResourceLocation location = Utils.instance.resources.createResourceLocation("angelblock", name);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)location);
        return Main.ENTITY_TYPES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)potionFactory, (MobCategory)MobCategory.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build(resourceKey));
    }
}

