/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.items.ItemRegistry;
import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.AmethystRod;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.ToolRegistry;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;

public class EndRod
extends AmethystRod {
    public EndRod(ModToolMaterial material, boolean isMagnetic, Item.Properties properties) {
        super(material, isMagnetic, properties);
    }

    @Override
    protected InteractionResult useOnInternal(UseOnContext context) {
        Player player = context.getPlayer();
        if (this.isEnhanced() && player.hasEffect(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT)) {
            return super.useOnInternal(context);
        }
        ItemStack itemStack = player.getItemInHand(context.getHand());
        if (!this.hasCriticalDamage(itemStack)) {
            BlockPos pos = context.getClickedPos();
            Level level = player.level();
            BlockState blockState = level.getBlockState(pos);
            Block block = blockState.getBlock();
            InteractionHand hand = context.getHand();
            Direction facing = context.getClickedFace();
            boolean isClientSide = level.isClientSide();
            if (facing == Direction.UP && block == Blocks.END_STONE && level.isEmptyBlock(pos.above())) {
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                return this.plant(player, level, pos, hand, facing, Blocks.CHORUS_FLOWER);
            }
            if (block == Blocks.TUFF) {
                if (!isClientSide) {
                    level.setBlock(pos, ((Block)BlockRegistry.DESTROYING_SALTPETER.get()).defaultBlockState(), 0);
                    level.destroyBlock(pos, true, (Entity)player, 1);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
        }
        return super.useOnInternal(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        LevelData levelData;
        ItemStack offHandItemStack = player.getOffhandItem();
        if (offHandItemStack.isEmpty()) return InteractionResult.PASS;
        if (this.hasCriticalDamage(player.getMainHandItem())) return InteractionResult.PASS;
        if (this.isEnhanced() && player.hasEffect(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT)) {
            return InteractionResult.PASS;
        }
        if (!this.utils.dimension.isOverworld((ResourceKey<Level>)level.dimension())) {
            return InteractionResult.FAIL;
        }
        Item offHandItem = offHandItemStack.getItem();
        if (offHandItem == ItemRegistry.FLAME_STONE.get()) {
            LevelData levelData2 = level.getLevelData();
            if (levelData2 instanceof ServerLevelData) {
                ServerLevelData levelData3 = (ServerLevelData)levelData2;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    this.playWeatherSound(serverPlayer);
                    levelData3.setRainTime(0);
                    levelData3.setThunderTime(0);
                    levelData3.setRaining(false);
                    levelData3.setThundering(false);
                    this.damageMainHandItem(1, (LivingEntity)player);
                    return InteractionResult.CONSUME;
                }
            }
            if (!((levelData2 = level.getLevelData()) instanceof ClientLevel.ClientLevelData)) return InteractionResult.CONSUME;
            ClientLevel.ClientLevelData levelData4 = (ClientLevel.ClientLevelData)levelData2;
            player.swing(interactionHand);
            levelData4.setRaining(false);
            return InteractionResult.CONSUME;
        }
        if (offHandItem == ItemRegistry.MARINE_CRYSTAL.get()) {
            LevelData weatherLasts2;
            LevelData levelData5 = level.getLevelData();
            if (levelData5 instanceof ServerLevelData) {
                ServerLevelData levelData6 = (ServerLevelData)levelData5;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    this.playWeatherSound(serverPlayer);
                    levelData6.setRaining(true);
                    levelData6.setThundering(false);
                    level.setRainLevel(0.3f);
                    level.setThunderLevel(0.0f);
                    if (levelData6.getRainTime() == 0) {
                        int weatherLasts2 = level.random.nextIntBetweenInclusive(1200, 24000);
                        levelData6.setRainTime(weatherLasts2);
                    }
                    levelData6.setThunderTime(0);
                    this.damageMainHandItem(1, (LivingEntity)player);
                    return InteractionResult.CONSUME;
                }
            }
            if (!((weatherLasts2 = level.getLevelData()) instanceof ClientLevel.ClientLevelData)) return InteractionResult.CONSUME;
            ClientLevel.ClientLevelData levelData7 = (ClientLevel.ClientLevelData)weatherLasts2;
            player.swing(interactionHand);
            levelData7.setRaining(true);
            level.setRainLevel(0.3f);
            level.setThunderLevel(0.0f);
            return InteractionResult.CONSUME;
        }
        if (offHandItem != ItemRegistry.STRENGTH_PEARL.get()) return InteractionResult.PASS;
        LevelData weatherLasts2 = level.getLevelData();
        if (weatherLasts2 instanceof ServerLevelData) {
            ServerLevelData levelData8 = (ServerLevelData)weatherLasts2;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.playWeatherSound(serverPlayer);
                levelData8.setClearWeatherTime(0);
                levelData8.setRaining(true);
                levelData8.setThundering(true);
                level.setThunderLevel(1.0f);
                level.setRainLevel(1.0f);
                if (levelData8.getRainTime() == 0 || levelData8.getThunderTime() == 0) {
                    int weatherLasts = level.random.nextIntBetweenInclusive(1200, 24000);
                    levelData8.setRainTime(weatherLasts);
                    levelData8.setThunderTime(weatherLasts);
                }
                this.damageMainHandItem(1, (LivingEntity)player);
                return InteractionResult.CONSUME;
            }
        }
        if (!((levelData = level.getLevelData()) instanceof ClientLevel.ClientLevelData)) return InteractionResult.CONSUME;
        ClientLevel.ClientLevelData levelData9 = (ClientLevel.ClientLevelData)levelData;
        player.swing(interactionHand);
        levelData9.setRaining(true);
        level.setThunderLevel(1.0f);
        level.setRainLevel(1.0f);
        return InteractionResult.CONSUME;
    }

    private void playWeatherSound(ServerPlayer serverPlayer) {
        serverPlayer.level().playSound(null, serverPlayer.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.MASTER);
    }

    private String getRodId() {
        return ToolRegistry.END_ROD.getRegisteredName();
    }

    @Override
    protected void appendPlacingBlockInfo(List<Component> tooltipComponents, boolean selectAsNew) {
        super.appendPlacingBlockInfo(tooltipComponents, false);
        for (int i = 2; i <= 3; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, false, false, false, false, selectAsNew, false));
        }
    }

    @Override
    protected void appendBlockTransformInfo(List<Component> tooltipComponents, boolean selectAsNew) {
        super.appendBlockTransformInfo(tooltipComponents, false);
        for (int i = 4; i <= 5; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, i == 4, false, false, false, selectAsNew, false));
        }
    }

    @Override
    protected void appendMagneticInfo(List<Component> tooltipComponents) {
        for (int i = 7; i <= 15; ++i) {
            if (i == 15) {
                tooltipComponents.add((Component)Component.empty());
            }
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, i == 7, false, false, false, false, i == 15));
        }
    }

    @Override
    protected void appendCommonPostInfo(List<Component> tooltipComponents) {
        for (int i = 16; i <= 17; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, false, false, false, false, false, i == 16));
        }
    }

    @Override
    protected int getOreDepth() {
        return 15;
    }

    @Override
    protected int getShiftingRadius() {
        return 3;
    }

    @Override
    protected int getRailsDetectionDepth() {
        return 128;
    }

    @Override
    protected int getSculkDetectionDepth() {
        return 192;
    }
}

