/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.pekar.angelblock.tools.IModToolEnhanceable;
import com.pekar.angelblock.tools.ModTool;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.properties.DefaultMaterialProperties;
import com.pekar.angelblock.tools.properties.IMaterialProperties;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.ITooltipProvider;
import com.pekar.angelblock.tooltip.TextStyle;
import com.pekar.angelblock.utils.Utils;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class ModShovel
extends ModTool
implements IModToolEnhanceable,
ITooltipProvider {
    protected final IMaterialProperties materialProperties;
    protected final Utils utils = new Utils();
    private final ModToolMaterial material;
    protected static final Map<Block, BlockState> FLATTENABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)Blocks.GRASS_BLOCK, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.PODZOL, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.COARSE_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.MYCELIUM, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.ROOTED_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).build());

    public static ModShovel createPrimary(ModToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        return new ModShovel(material, attackDamage, attackSpeed, properties, new DefaultMaterialProperties());
    }

    public ModShovel(ModToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties, IMaterialProperties materialProperties) {
        super(material, (TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL, attackDamage, attackSpeed, properties);
        this.materialProperties = materialProperties;
        this.material = material;
        FLATTENABLES.put(Blocks.FARMLAND, Blocks.DIRT_PATH.defaultBlockState());
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult result;
        BlockPos pos;
        Player player = context.getPlayer();
        Level level = player.level();
        BlockState blockState = level.getBlockState(pos = context.getClickedPos());
        Block block = blockState.getBlock();
        if ((FLATTENABLES.containsKey(block) || block instanceof CampfireBlock && ((Boolean)blockState.getValue((Property)CampfireBlock.LIT)).booleanValue()) && (result = this.useOnBasic(context)) == InteractionResult.PASS) {
            this.onBlockProcessing(player, level, pos, pos, context.getHorizontalDirection());
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean isTool() {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
        int modifiedDamage = Mth.clamp((int)damage, (int)0, (int)(stack.getMaxDamage() - this.getCriticalDurability()));
        stack.set(DataComponents.DAMAGE, (Object)modifiedDamage);
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return !this.hasCriticalDamage(stack) && super.isCorrectToolForDrops(stack, state);
    }

    @Override
    public ModToolMaterial getMaterial() {
        return this.material;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.hasCriticalDamage(stack)) {
            return 1.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return !this.hasCriticalDamage(stack) && ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(itemAbility);
    }

    public final void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ITooltipProvider.appendHoverText(this, stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    public final IMaterialProperties getMaterialProperties() {
        return this.materialProperties;
    }

    protected boolean onBlockProcessing(Player player, Level level, BlockPos originalPos, BlockPos pos, Direction facing) {
        if (!level.isEmptyBlock(pos.above())) {
            return false;
        }
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (FLATTENABLES.containsKey(block)) {
            if (!level.isClientSide) {
                BlockState newBlockState = Blocks.DIRT_PATH.defaultBlockState();
                level.setBlock(pos, newBlockState, 11);
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
            }
            this.utils.sound.playSoundByBlock(player, pos, SoundEvents.SHOVEL_FLATTEN);
            return true;
        }
        return false;
    }

    private InteractionResult useOnBasic(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        if (context.getClickedFace() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        BlockState blockstate1 = blockstate.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false);
        BlockState blockstate2 = null;
        if (blockstate1 != null && level.getBlockState(blockpos.above()).isAir()) {
            level.playSound(player, blockpos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else {
            blockstate2 = blockstate.getToolModifiedState(context, ItemAbilities.SHOVEL_DOUSE, false);
            if (blockstate2 != null && !level.isClientSide()) {
                level.levelEvent((Player)null, 1009, blockpos, 0);
            }
        }
        if (blockstate2 != null) {
            if (!level.isClientSide) {
                level.setBlock(blockpos, blockstate2, 11);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)blockstate2));
                if (player != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        for (int i = 0; i <= 3; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.DarkGray, i == 2).apply();
        }
    }
}

