/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.ModSword;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class RendelithicSword
extends ModSword {
    public RendelithicSword(ModToolMaterial material, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = player.level();
        if (!this.canUseToolEffect(player)) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        if (player.hasEffect(PotionRegistry.SWORD_FIRE_MODE_EFFECT)) {
            if (!level.isClientSide()) {
                InteractionHand hand = context.getHand();
                if (Math.abs(player.blockPosition().getX() - pos.getX()) < 2 && Math.abs(player.blockPosition().getZ() - pos.getZ()) < 2) {
                    this.setEffectAround(player, hand, level, pos);
                } else {
                    this.setEffectAhead(player, hand, level, pos);
                }
            }
            return this.getToolInteractionResult(true, level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void additionalActionOnHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.hasEffect(PotionRegistry.SWORD_FIRE_MODE_EFFECT)) {
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, 400, 0, true, true));
        }
    }

    @Override
    protected void processBlock(Player player, InteractionHand interactionHand, Level level, BlockPos pos) {
        this.trySetFire(level, pos);
    }

    @Override
    public boolean hasFireMode() {
        return true;
    }

    @Override
    public boolean isEnhanced() {
        return true;
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        for (int i = 0; i <= 8; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1 || i == 3).styledAs(TextStyle.DarkGray, i >= 5 && i <= 7).apply();
        }
    }
}

