/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.armor;

import com.pekar.angelblock.armor.ArmorModifications;
import com.pekar.angelblock.armor.ModArmorMaterial;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.ITooltipProvider;
import com.pekar.angelblock.tooltip.TextStyle;
import com.pekar.angelblock.utils.Utils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorType;
import org.jetbrains.annotations.Nullable;

public class ModArmor
extends Item
implements ITooltipProvider {
    protected final ArmorType armorItemType;
    protected final int maxDamage;
    protected final ModArmorMaterial material;
    protected final Utils utils = new Utils();
    private final Set<ArmorModifications> armorModificatorSet = new HashSet<ArmorModifications>();
    protected boolean canFly;

    protected ModArmor(ModArmorMaterial material, ArmorType armorItemType, Item.Properties properties) {
        super(material.isFireResistant() ? properties.humanoidArmor(material.getMaterial(), armorItemType).fireResistant() : properties.humanoidArmor(material.getMaterial(), armorItemType));
        this.material = material;
        this.armorItemType = armorItemType;
        this.maxDamage = armorItemType.getDurability(material.getDurabilityMultiplier());
    }

    public ModArmorMaterial getArmorMaterial() {
        return this.material;
    }

    public String getArmorFamilyName() {
        return this.material.getMaterialName() + "_armor";
    }

    public ModArmor canFly() {
        this.canFly = true;
        return this;
    }

    private boolean isAutoFlightDamage(ItemStack stack, @Nullable LivingEntity entity, int amount) {
        Player player;
        if (!this.canFly) {
            return false;
        }
        return entity instanceof Player && (player = (Player)entity).isFallFlying() && amount <= 1;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (this.isAutoFlightDamage(stack, entity, amount)) {
            return 0;
        }
        int durability = stack.getMaxDamage() - stack.getDamageValue();
        if (entity != null) {
            this.utils.attributeModifiers.updateArmorAttributeModifier(entity);
        }
        if (amount >= durability) {
            stack.setDamageValue(stack.getMaxDamage() - 1);
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBroken(ItemStack stack) {
        return stack.getMaxDamage() - stack.getDamageValue() <= 1;
    }

    public final boolean isModifiedWithDetector() {
        return this.armorModificatorSet.contains((Object)ArmorModifications.Detector);
    }

    public final boolean isModifiedWithNightVision() {
        return this.armorModificatorSet.contains((Object)ArmorModifications.NightVision);
    }

    public final boolean isModifiedWithHealthRegenerator() {
        return this.armorModificatorSet.contains((Object)ArmorModifications.Regenerator);
    }

    public final boolean isModifiedWithStrengthBooster() {
        return this.armorModificatorSet.contains((Object)ArmorModifications.StrengthBooster);
    }

    public final boolean isModifiedWithJumpBooster() {
        return this.armorModificatorSet.contains((Object)ArmorModifications.JumpBooster);
    }

    public final boolean isModifiedWithSlowFalling() {
        return this.armorModificatorSet.contains((Object)ArmorModifications.SlowFalling);
    }

    public final boolean isModifiedWithSeaPower() {
        return this.armorModificatorSet.contains((Object)ArmorModifications.SeaPower);
    }

    public final boolean isModifiedWithElytra() {
        return this.armorModificatorSet.contains((Object)ArmorModifications.Elytra);
    }

    public final boolean isModifiedWithLuck() {
        return this.armorModificatorSet.contains((Object)ArmorModifications.Luck);
    }

    public final ModArmor withDetector() {
        this.armorModificatorSet.add(ArmorModifications.Detector);
        return this;
    }

    public final ModArmor withNightVision() {
        this.armorModificatorSet.add(ArmorModifications.NightVision);
        return this;
    }

    public final ModArmor withHealthRegenerator() {
        this.armorModificatorSet.add(ArmorModifications.Regenerator);
        return this;
    }

    public final ModArmor withStrengthBooster() {
        this.armorModificatorSet.add(ArmorModifications.StrengthBooster);
        return this;
    }

    public final ModArmor withJumpBooster() {
        this.armorModificatorSet.add(ArmorModifications.JumpBooster);
        return this;
    }

    public final ModArmor withSlowFalling() {
        this.armorModificatorSet.add(ArmorModifications.SlowFalling);
        return this;
    }

    public final ModArmor withSeaPower() {
        this.armorModificatorSet.add(ArmorModifications.SeaPower);
        return this;
    }

    public final ModArmor withLuck() {
        this.armorModificatorSet.add(ArmorModifications.Luck);
        return this;
    }

    public final ModArmor withElytra() {
        this.armorModificatorSet.add(ArmorModifications.Elytra);
        return this;
    }

    public int getMaxDamage() {
        return (Integer)this.components().getOrDefault(DataComponents.MAX_DAMAGE, (Object)this.maxDamage);
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!(flag.hasShiftDown() || flag.hasAltDown() || flag.hasControlDown())) {
            tooltip.addLineById("description.common.press_shift_alt_or_ctrl").apply();
            return;
        }
        if (flag.hasShiftDown()) {
            tooltip.ignoreEmptyLines();
            for (int i = 1; i <= 9; ++i) {
                tooltip.addLine(this.getCommonDescriptionRoot(), i).styledAs(TextStyle.Header, i == 5).apply();
            }
            tooltip.addEmptyLine();
            tooltip.addLineById("description.armor.press_alt").apply();
            tooltip.addLineById("description.armor.press_ctrl").apply();
            return;
        }
        if (flag.hasAltDown()) {
            tooltip.includeEmptyLines();
            for (int i = 1; i <= this.getDescriptionLineCount(); ++i) {
                tooltip.addLine(this.getSpecificDescriptionRoot(), i).styledAs(TextStyle.Header, i == 1).styledAs(TextStyle.Notice, this.armorItemType.getSlot() == EquipmentSlot.FEET && i == 9).apply();
            }
            tooltip.addEmptyLine();
            tooltip.addLineById("description.armor.press_shift").apply();
            tooltip.addLineById("description.armor.press_ctrl").apply();
            return;
        }
        if (flag.hasControlDown()) {
            tooltip.ignoreEmptyLines();
            for (int i = 10; i <= 14; ++i) {
                tooltip.addLine(this.getCommonDescriptionRoot(), i).styledAs(TextStyle.DarkGray, true).apply();
            }
            tooltip.addEmptyLine();
            tooltip.addLineById("description.armor.press_shift").apply();
            tooltip.addLineById("description.armor.press_alt").apply();
            return;
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> component, TooltipFlag flag) {
        ITooltipProvider.appendHoverText(this, stack, context, display, component, flag);
    }

    private int getDescriptionLineCount() {
        return switch (this.armorItemType.getSlot()) {
            case EquipmentSlot.HEAD -> 6;
            case EquipmentSlot.CHEST -> 9;
            case EquipmentSlot.LEGS -> 6;
            case EquipmentSlot.FEET -> 9;
            default -> 0;
        };
    }

    private String getSpecificDescriptionRoot() {
        return this.getDescriptionId();
    }

    private String getCommonDescriptionRoot() {
        return this.getFullArmorModelName(this.getArmorFamilyName()).replace(':', '.').replaceAll("[0-9]", "");
    }

    private String getFullArmorModelName(String armorModelName) {
        return "angelblock:" + armorModelName;
    }
}

