/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.blocks.tile_entities;

import com.pekar.angelblock.utils.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class DespawnMonsterBlockEntity<T extends BlockEntity>
extends BlockEntity
implements BlockEntityTicker<T> {
    private final Utils utils = new Utils();

    public DespawnMonsterBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void tick(Level level, BlockPos pos, BlockState blockState, T entity) {
        if (level.getGameTime() % 15L == 0L) {
            this.onUpdate(level, entity);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadModTag(tag);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveModTag(tag);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveModTag(tag);
        return tag;
    }

    protected abstract void loadModTag(CompoundTag var1);

    protected abstract void saveModTag(CompoundTag var1);

    protected abstract double getEffectiveRadius();

    protected abstract boolean needToDespawnEntity(Entity var1);

    private void onUpdate(Level level, T blockEntity) {
        if (level.isClientSide()) {
            return;
        }
        List monsters = level.getEntitiesOfClass(LivingEntity.class, this.utils.getRenderBoundingBox(blockEntity.getBlockPos()).inflate(this.getEffectiveRadius()), this::needToDespawnEntity);
        for (Entity entity : monsters) {
            entity.discard();
        }
    }
}

