/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.armor;

import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.network.packets.CreeperDetectedPacket;
import com.pekar.angelblock.utils.TriPredicate;
import com.pekar.angelblock.utils.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

abstract class Armor
implements IArmor {
    protected final IPlayer player;
    private final Set<EquipmentSlot> equipmentSlots = new HashSet<EquipmentSlot>();
    private final CreeperDetectedPacket creeperDetectedPacket = new CreeperDetectedPacket();
    private int creeperDetectedCounter = 0;
    private boolean needUpdateStatesAfterLogin = false;
    private static final double CREEPER_NOTIFY_DISTANCE = 17.0;
    private static final double CREEPER_AGRY_DISTANCE = 3.0;
    private static final int CREEPER_GLOWING_EFFECT_DURATION = 20;
    protected static final float EXHAUSTION_INCREMENT = 0.5f;
    protected static final int UNDER_RAIN_REGENERATION_EFFECT_DURATION = 100;
    protected final TriPredicate<Block, BlockPos, Level> isIcePredicate = (block, pos, level) -> {
        BlockState belowBlockState = level.getBlockState(pos.below());
        return block == Blocks.ICE && (belowBlockState.isAir() || Utils.instance.blocks.types.isLiquid(belowBlockState.getBlock()));
    };
    protected final TriPredicate<Block, BlockPos, Level> isCrackedBlockPredicate = (block, pos, level) -> block == BlockRegistry.CRACKED_ENDSTONE.get() || block == BlockRegistry.CRACKED_OBSIDIAN.get();
    protected final TriPredicate<Block, BlockPos, Level> isNetherrackPredicate = (block, pos, level) -> block == Blocks.NETHERRACK;
    protected final BiConsumer<ServerPlayer, BlockPos> playIceBreakSound = (player, pos) -> {
        player.level().playSound(null, pos, SoundEvents.GLASS_BREAK, SoundSource.BLOCKS);
        player.level().playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS);
    };
    protected final BiConsumer<ServerPlayer, BlockPos> playCrackedBlockBreakSound = (player, pos) -> player.level().playSound(null, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 1.0f, 2.0f);

    protected Armor(IPlayer player2) {
        this.player = player2;
        this.equipmentSlots.add(EquipmentSlot.FEET);
        this.equipmentSlots.add(EquipmentSlot.LEGS);
        this.equipmentSlots.add(EquipmentSlot.CHEST);
        this.equipmentSlots.add(EquipmentSlot.HEAD);
    }

    protected abstract void updateAvailability();

    protected abstract void updateEffectStates();

    protected abstract void updateActivityForHeadSlot();

    protected abstract void updateActivityForFeetSlot();

    protected abstract void updateActivityForLegsSlot();

    protected abstract void updateActivityForChestSlot();

    protected void updateActivityForHandSlots() {
    }

    protected abstract void updateActivity(EquipmentSlot var1);

    protected void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
    }

    protected void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @Override
    public final void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        this.needUpdateStatesAfterLogin = true;
        this.onLogin(event);
    }

    @Override
    public final void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        this.updateAvailability();
        if (this.needUpdateStatesAfterLogin) {
            this.updateEffectStates();
            this.needUpdateStatesAfterLogin = false;
        }
        switch (event.getSlot()) {
            case CHEST: {
                this.updateActivityForChestSlot();
                break;
            }
            case LEGS: {
                this.updateActivityForLegsSlot();
                break;
            }
            case FEET: {
                this.updateActivityForFeetSlot();
                break;
            }
            case HEAD: {
                this.updateActivityForHeadSlot();
                break;
            }
            case MAINHAND: 
            case OFFHAND: {
                this.updateActivityForHeadSlot();
                this.updateActivityForChestSlot();
                this.updateActivityForLegsSlot();
                this.updateActivityForFeetSlot();
                this.updateActivityForHandSlots();
            }
        }
        this.updateActivity(event.getSlot());
        this.onEquipmentChangeEvent(event);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Armor)) {
            return false;
        }
        Armor armor = (Armor)obj;
        return this.getFamilyName().equals(armor.getFamilyName());
    }

    public int hashCode() {
        return this.getFamilyName().hashCode();
    }

    protected boolean isFreezeDamage(DamageSource damageSource) {
        return damageSource.is(DamageTypes.FREEZE);
    }

    protected boolean isFireDamage(DamageSource damageSource) {
        boolean isDamagedByInFire = damageSource.is(DamageTypes.IN_FIRE);
        boolean isDamagedByOnFire = damageSource.is(DamageTypes.ON_FIRE);
        return isDamagedByInFire || isDamagedByOnFire;
    }

    protected boolean isStandingInSoulFire() {
        return false;
    }

    protected boolean isLavaDamage(DamageSource damageSource) {
        return damageSource.is(DamageTypes.LAVA);
    }

    protected boolean isHotFloorDamage(DamageSource damageSource) {
        return damageSource.is(DamageTypes.HOT_FLOOR);
    }

    protected boolean isFireOrLavaDamage(DamageSource damageSource) {
        return this.isFireDamage(damageSource) || this.isLavaDamage(damageSource);
    }

    protected boolean isFireOrLavaOrHotFloorDamage(DamageSource damageSource) {
        return this.isHotFloorDamage(damageSource) || this.isFireOrLavaDamage(damageSource);
    }

    protected boolean isThornOrMagicDamage(DamageSource damageSource) {
        boolean isCactus = damageSource.is(DamageTypes.CACTUS);
        boolean isSweetBerryBush = damageSource.is(DamageTypes.SWEET_BERRY_BUSH);
        boolean isPufferFish = damageSource.getEntity() instanceof Pufferfish;
        boolean isMagic = damageSource.is(DamageTypes.MAGIC) || damageSource.is(DamageTypes.INDIRECT_MAGIC);
        return isCactus || isSweetBerryBush || isMagic || isPufferFish;
    }

    protected boolean isLightningBoltDamage(DamageSource damageSource) {
        return damageSource.is(DamageTypes.LIGHTNING_BOLT);
    }

    protected boolean isExplosionDamage(DamageSource damageSource) {
        return damageSource.is(DamageTypes.EXPLOSION);
    }

    protected boolean isBiting(Entity entity) {
        boolean isSilverfish = entity instanceof Silverfish;
        boolean isEndermite = entity instanceof Endermite;
        boolean isSpider = entity instanceof Spider;
        boolean isBee = entity instanceof Bee;
        return isSilverfish || isEndermite || isSpider || isBee;
    }

    protected boolean isSlowMovementAffected(LivingEntity entity) {
        boolean isZombie = entity instanceof Zombie;
        boolean isSkeleton = entity instanceof Skeleton;
        boolean isWitch = entity instanceof Witch;
        boolean isIllager = entity instanceof AbstractIllager;
        return isZombie || isSkeleton || isIllager || isWitch;
    }

    protected void detectCreepers(boolean detect, boolean makeNeutral) {
        if (!detect && !makeNeutral) {
            return;
        }
        Player entityPlayer = this.player.getEntity();
        Level level = entityPlayer.level();
        if (level.isClientSide()) {
            return;
        }
        List monsters = level.getEntitiesOfClass(Creeper.class, entityPlayer.getBoundingBox().inflate(17.0));
        if (!monsters.isEmpty()) {
            for (Creeper entity : monsters) {
                if (detect && (!entity.hasEffect(MobEffects.GLOWING) || entity.getEffect(MobEffects.GLOWING).getDuration() < 10)) {
                    MobEffectInstance potionEffect = new MobEffectInstance(MobEffects.GLOWING, 20, 0, false, false, false);
                    entity.addEffect(potionEffect);
                }
                if (!makeNeutral || !((double)entity.distanceTo((Entity)entityPlayer) >= 3.0) || entity.getTarget() != entityPlayer) continue;
                entity.setTarget(null);
            }
            if (detect) {
                if (this.creeperDetectedCounter > 3) {
                    this.creeperDetectedCounter = 0;
                } else if (this.creeperDetectedCounter++ == 0) {
                    this.creeperDetectedPacket.sendToPlayer((ServerPlayer)entityPlayer);
                }
            }
        } else if (detect) {
            this.creeperDetectedCounter = 0;
        }
    }

    protected void breakBlockUnderPlayer(ServerPlayer player, boolean doRandomly, TriPredicate<Block, BlockPos, Level> blockUnderPlayer, BlockState stateToTransformTo, BiConsumer<ServerPlayer, BlockPos> runOnSucceeded, int chanceToAvoidBreaking) {
        boolean shouldIceBeBroken;
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        BlockPos posBelow = BlockPos.containing((double)player.getX(), (double)(player.getY() - 0.5), (double)player.getZ());
        Block block1 = level.getBlockState(posBelow).getBlock();
        if (!blockUnderPlayer.test(block1, posBelow, level)) {
            return;
        }
        RandomSource randomSource = RandomSource.create();
        int heavyArmorSlots = 0;
        for (ItemStack slot : Utils.instance.player.getArmorInSlots((LivingEntity)player)) {
            ModArmor modArmor;
            Item item = slot.getItem();
            if (!(item instanceof ModArmor) || !(modArmor = (ModArmor)item).getArmorFamilyName().equals(this.getFamilyName())) continue;
            ++heavyArmorSlots;
        }
        int rnd = randomSource.nextInt(chanceToAvoidBreaking);
        boolean bl = shouldIceBeBroken = rnd <= heavyArmorSlots * heavyArmorSlots;
        if (doRandomly && !shouldIceBeBroken) {
            return;
        }
        for (int x = posBelow.getX() - 1; x <= posBelow.getX() + 1; ++x) {
            for (int z = posBelow.getZ() - 1; z <= posBelow.getZ() + 1; ++z) {
                BlockPos currentPos = new BlockPos(x, posBelow.getY(), z);
                block1 = level.getBlockState(currentPos).getBlock();
                if (!blockUnderPlayer.test(block1, currentPos, level)) continue;
                if (stateToTransformTo.isAir()) {
                    level.destroyBlock(currentPos, true, (Entity)player);
                    continue;
                }
                level.setBlock(currentPos, stateToTransformTo, 11);
            }
        }
        runOnSucceeded.accept(player, posBelow);
    }

    protected void restorePlayerHealth(Player entityPlayer) {
        AttributeInstance maxHealthAttr = entityPlayer.getAttribute(Attributes.MAX_HEALTH);
        if (maxHealthAttr != null) {
            double maxBaseHealth = maxHealthAttr.getBaseValue();
            if ((double)entityPlayer.getHealth() >= maxBaseHealth) {
                entityPlayer.setHealth(entityPlayer.getMaxHealth());
            }
        }
    }

    protected boolean playerNeedsToRestoreHealth(Player entityPlayer, EquipmentSlot slotChanged, ItemStack itemFrom, ItemStack itemTo) {
        if (entityPlayer.isCreative()) {
            return false;
        }
        if (itemFrom.getItem().equals(itemTo.getItem())) {
            return false;
        }
        if (!this.player.isArmorElementPutOn(this, EquipmentSlot.LEGS) || !this.player.areLeggingsModifiedWithHealthRegenerator(this)) {
            return false;
        }
        if (slotChanged == EquipmentSlot.LEGS) {
            return true;
        }
        return itemFrom.is(Items.MILK_BUCKET) && itemTo.is(Items.BUCKET);
    }

    protected void damageArmor(boolean damage) {
        for (ItemStack item : Utils.instance.player.getArmorInSlots((LivingEntity)this.player.getEntity())) {
            int damageValue = damage ? item.getMaxDamage() - 1 : 0;
            item.setDamageValue(damageValue);
        }
    }

    protected void damageMainHandItem() {
        ItemStack itemStack = this.player.getEntity().getMainHandItem();
        int maxDamage = itemStack.getMaxDamage();
        int newDamage = maxDamage * 2 / 3 - 2;
        itemStack.setDamageValue(newDamage);
    }

    protected void switchArmorDamage() {
        ModArmor modArmor;
        Item item;
        boolean isDamaged = false;
        for (ItemStack slot : Utils.instance.player.getArmorInSlots((LivingEntity)this.player.getEntity())) {
            if (slot.isEmpty() || !((item = slot.getItem()) instanceof ModArmor) || !(modArmor = (ModArmor)item).isDamaged(slot)) continue;
            isDamaged = true;
        }
        for (ItemStack slot : Utils.instance.player.getArmorInSlots((LivingEntity)this.player.getEntity())) {
            if (slot.isEmpty() || !((item = slot.getItem()) instanceof ModArmor)) continue;
            modArmor = (ModArmor)item;
            this.damageArmor(!isDamaged);
        }
    }

    protected final boolean isVulnerable(DamageSource damageSource) {
        TagKey vulnerabilities = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)this.getVulnerabilitiesTagName()));
        return damageSource.is(vulnerabilities);
    }

    protected String getVulnerabilitiesTagName() {
        return this.getFamilyName() + "_armor_vulnerabilities";
    }
}

