/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.network;

import com.pekar.angelblock.network.IPacketInfoProvider;
import com.pekar.angelblock.network.Packet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

class PacketInfoProvider<T extends Packet>
implements IPacketInfoProvider<T> {
    private final T packet;

    PacketInfoProvider(T packet) {
        this.packet = packet;
    }

    @Override
    public CustomPacketPayload.Type<T> getType() {
        return ((Packet)this.packet).type();
    }

    @Override
    public StreamCodec<FriendlyByteBuf, T> getStreamCodec() {
        return StreamCodec.of(this.getEncoder(), this.getDecoder());
    }

    @Override
    public IPayloadHandler<T> getHandler() {
        return this.getPacketHandler();
    }

    private StreamEncoder<FriendlyByteBuf, T> getEncoder() {
        return (buffer, packet) -> packet.encode((FriendlyByteBuf)buffer);
    }

    private StreamDecoder<FriendlyByteBuf, T> getDecoder() {
        return buffer -> (Packet)this.packet.decode((FriendlyByteBuf)buffer);
    }

    private IPayloadHandler<T> getPacketHandler() {
        return (packet, context) -> packet.handlePacket(context);
    }
}

