/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.ModSword;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import com.pekar.angelblock.utils.SoundType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LimoniteSword
extends ModSword {
    public LimoniteSword(ModToolMaterial material, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = player.level();
        if (!this.canUseToolEffect(player)) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        if (player.hasEffect(PotionRegistry.SWORD_WEB_MODE_EFFECT)) {
            InteractionHand hand = context.getHand();
            BlockState blockState = level.getBlockState(pos);
            if (player.isShiftKeyDown() && this.utils.blocks.types.isCactiPlantableOn(blockState)) {
                if (!level.isClientSide()) {
                    this.plantCacti(player, level, pos, hand, context.getClickedFace());
                }
                this.utils.sound.playSoundByBlock(player, pos, SoundType.PLANT);
            } else if (Math.abs(player.blockPosition().getX() - pos.getX()) < 2 && Math.abs(player.blockPosition().getZ() - pos.getZ()) < 2) {
                if (!level.isClientSide()) {
                    this.setEffectAround(player, hand, level, pos);
                }
                this.utils.sound.playSoundByBlock(player, pos, SoundType.BLOCK_CHANGED);
            } else {
                if (!level.isClientSide()) {
                    this.setEffectAhead(player, hand, level, pos);
                }
                this.utils.sound.playSoundByBlock(player, pos, SoundType.BLOCK_CHANGED);
            }
            return this.getToolInteractionResult(true, level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void additionalActionOnHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.hasEffect(PotionRegistry.SWORD_WEB_MODE_EFFECT)) {
            target.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0, true, true));
        }
        target.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 400, 0, true, true));
    }

    @Override
    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        if (this.hasCriticalDamage(itemStack)) {
            return 1.0f;
        }
        Block block = blockState.getBlock();
        if (block == Blocks.COBWEB) {
            return 60.0f;
        }
        if (block == Blocks.CACTUS) {
            return 40.0f;
        }
        return super.getDestroySpeed(itemStack, blockState);
    }

    @Override
    protected void processBlock(Player player, InteractionHand interactionHand, Level level, BlockPos pos) {
        this.setWeb(player, level, pos.above());
    }

    @Override
    public boolean isEnhanced() {
        return true;
    }

    @Override
    public boolean hasWebMode() {
        return true;
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        tooltip.ignoreEmptyLines();
        for (int i = 0; i <= 14; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1 || i == 5).styledAs(TextStyle.Subheader, i == 6).styledAs(TextStyle.Notice, i == 8 || i == 10).styledAs(TextStyle.DarkGray, i >= 11 && i <= 13).apply();
        }
    }
}

