/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.cleaners;

import com.pekar.angelblock.events.cleaners.BlockTargetBehavior;
import com.pekar.angelblock.events.cleaners.ITargetBehavior;
import com.pekar.angelblock.events.cleaners.TrackedTarget;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class TrackedBlock
extends TrackedTarget<Block> {
    private final boolean removeWhenClosely;
    private final BlockPos pos;

    public TrackedBlock(Block block, BlockPos pos, Player owner, int ticksBeforeRemoving, boolean removeWhenClosely) {
        super(block, owner, ticksBeforeRemoving);
        this.pos = pos;
        this.removeWhenClosely = removeWhenClosely;
    }

    @Override
    protected ITargetBehavior createBehavior() {
        return new BlockTargetBehavior(this);
    }

    @Override
    public ServerLevel getTargetLevel() {
        return (ServerLevel)this.getOwner().level();
    }

    @Override
    public void remove() {
        ServerLevel level = this.getTargetLevel();
        if (!level.isEmptyBlock(this.pos)) {
            level.destroyBlock(this.pos, false);
        }
    }

    @Override
    public String getId() {
        return ((Block)this.getTargetInstance()).getDescriptionId() + this.pos.asLong();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean needToRemoveWhenClosely() {
        return this.removeWhenClosely;
    }
}

