/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.blocks;

import com.pekar.angelblock.blocks.ModBlock;
import com.pekar.angelblock.blocks.tile_entities.DevilBlockEntity;
import com.pekar.angelblock.blocks.tile_entities.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DevilBlock
extends ModBlock
implements EntityBlock {
    public DevilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DevilBlockEntity) {
            DevilBlockEntity devilBlockEntity = (DevilBlockEntity)blockEntity;
            ItemStack interactionItemStack = player.getItemInHand(hand);
            if (interactionItemStack.isEmpty()) {
                return InteractionResult.FAIL;
            }
            Item interactionItem = interactionItemStack.getItem();
            if (!level.isClientSide()) {
                devilBlockEntity.spawnMonster(interactionItem, player, interactionItemStack);
            }
            return this.getInteractionSidedSuccess(level.isClientSide());
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)EntityRegistry.DEVIL_BLOCK_ENTITY.get()).create(blockPos, blockState);
    }

    public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
        this.disposeBlockEntity((LevelAccessor)level, pos);
        super.onBlockExploded(state, level, pos, explosion);
    }

    private void disposeBlockEntity(LevelAccessor level, BlockPos pos) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DevilBlockEntity) {
            DevilBlockEntity devilBlockEntity = (DevilBlockEntity)blockEntity;
            devilBlockEntity.dispose();
        }
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        this.disposeBlockEntity(level, pos);
        super.destroy(level, pos, state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.disposeBlockEntity((LevelAccessor)level, pos);
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : (level0, pos, blockState0, blockEntity) -> ((DevilBlockEntity)blockEntity).tick(level0, pos, blockState0, (DevilBlockEntity)blockEntity);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!level.isClientSide()) {
            level.playSound(null, pos, (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

