/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.armor;

import com.pekar.angelblock.armor.ArmorRegistry;
import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.events.armor.Armor;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.effect.BlindnessNegativeArmorEffect;
import com.pekar.angelblock.events.effect.DolphinsGraceSwitchingEffect;
import com.pekar.angelblock.events.effect.GlowingSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.HastePermanentArmorEffect;
import com.pekar.angelblock.events.effect.IPermanentArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingArmorEffect;
import com.pekar.angelblock.events.effect.ITemporaryArmorEffect;
import com.pekar.angelblock.events.effect.ITemporaryPersistentArmorEffect;
import com.pekar.angelblock.events.effect.LuckPermanentArmorEffect;
import com.pekar.angelblock.events.effect.NightVisionSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.RegenerationTemporaryArmorEffect;
import com.pekar.angelblock.events.effect.StrengthPermanentArmorEffect;
import com.pekar.angelblock.events.effect.WaterBreathingPermanentEffect;
import com.pekar.angelblock.events.effect.WitherNegativeEffect;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.keybinds.KeyRegistry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class LapisArmor
extends Armor {
    private final IPermanentArmorEffect waterBreathingEffect;
    private final IPermanentArmorEffect hasteEffect;
    private final IPermanentArmorEffect luckEffect;
    private final IPermanentArmorEffect strengthEffect;
    private final ITemporaryArmorEffect regenerationEffect;
    private final ITemporaryPersistentArmorEffect blindnessEffect;
    private final ITemporaryPersistentArmorEffect witherEffect;
    private final ISwitchingArmorEffect dolphinsGrace;
    private final ISwitchingArmorEffect nightVisionEffect;
    private final ISwitchingArmorEffect glowingEffect;
    private static final int REGENERATION_EFFECT_DURATION = 300;
    private static final int REGENERATION_NEGATIVE_EFFECT_DURATION = 200;

    public LapisArmor(IPlayer player) {
        super(player);
        this.nightVisionEffect = (ISwitchingArmorEffect)new NightVisionSwitchingArmorEffect(player, this).availableOnHelmetWithNightVision();
        this.glowingEffect = (ISwitchingArmorEffect)new GlowingSwitchingArmorEffect(player, this).availableIfSlotSet(EquipmentSlot.CHEST);
        this.waterBreathingEffect = new WaterBreathingPermanentEffect(player, this);
        this.hasteEffect = new HastePermanentArmorEffect(player, this);
        this.luckEffect = (IPermanentArmorEffect)new LuckPermanentArmorEffect(player, this).availableIfSlotSet(EquipmentSlot.CHEST);
        this.regenerationEffect = new RegenerationTemporaryArmorEffect(player, (IArmor)this, 0, 300);
        this.blindnessEffect = (ITemporaryPersistentArmorEffect)new BlindnessNegativeArmorEffect(player, this, 200).showIcon();
        this.witherEffect = (ITemporaryPersistentArmorEffect)new WitherNegativeEffect(player, (IArmor)this, 0, 600).showIcon();
        this.strengthEffect = (IPermanentArmorEffect)new StrengthPermanentArmorEffect(player, this, 0).availableOnChestPlateWithStrengthBooster();
        this.dolphinsGrace = new DolphinsGraceSwitchingEffect(player, this);
    }

    @Override
    protected void updateAvailability() {
        this.nightVisionEffect.updateAvailability();
        this.hasteEffect.updateAvailability();
        this.waterBreathingEffect.updateAvailability();
        this.luckEffect.updateAvailability();
        this.glowingEffect.updateAvailability();
        this.regenerationEffect.updateAvailability();
        this.blindnessEffect.updateAvailability();
        this.witherEffect.updateAvailability();
        this.strengthEffect.updateAvailability();
        this.dolphinsGrace.updateAvailability();
    }

    @Override
    protected void updateEffectStates() {
        this.nightVisionEffect.updateSwitchState();
        this.glowingEffect.updateSwitchState();
        this.dolphinsGrace.updateSwitchState();
    }

    @Override
    protected void updateActivityForHeadSlot() {
        this.nightVisionEffect.updateActivity();
        this.waterBreathingEffect.updateActivity();
    }

    @Override
    protected void updateActivityForFeetSlot() {
        this.dolphinsGrace.updateActivity();
    }

    @Override
    protected void updateActivityForLegsSlot() {
        this.regenerationEffect.updateActivity();
    }

    @Override
    protected void updateActivityForChestSlot() {
        this.hasteEffect.updateActivity();
        this.luckEffect.updateActivity();
        this.glowingEffect.updateActivity();
        this.strengthEffect.updateActivity();
    }

    @Override
    protected void updateActivity(EquipmentSlot slot) {
        this.blindnessEffect.updateActivity();
    }

    @Override
    public void onLivingHurtEvent(LivingIncomingDamageEvent event) {
    }

    @Override
    public void onLivingDamageEvent(LivingDamageEvent.Pre event) {
        DamageSource damageSource = event.getSource();
        if (this.isFireOrMagmaDamage(damageSource) && !this.witherEffect.isActive()) {
            this.witherEffect.tryActivate();
        }
        if (this.isVulnerable(damageSource)) {
            event.setNewDamage(event.getNewDamage() * 1.2f);
        } else if (this.isFreezeDamage(damageSource)) {
            event.setNewDamage(event.getNewDamage() * 2.0f);
        }
    }

    @Override
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
    }

    @Override
    public void onLivingFallEvent(LivingFallEvent event) {
    }

    @Override
    public void onCreeperCheck() {
    }

    @Override
    public void onEffectAddedEvent(MobEffectEvent.Added event) {
    }

    @Override
    public void onKeyInputEvent(String pressedKeyDescription) {
        if (pressedKeyDescription.equals(KeyRegistry.NIGHT_VISION.getName())) {
            this.nightVisionEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.GLOWING.getName())) {
            this.glowingEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.JUMP_BOOST.getName())) {
            this.dolphinsGrace.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.REGENERATION.getName()) && this.regenerationEffect.isAvailable() && !this.regenerationEffect.isAnyActive() && this.player.getEntity().getHealth() < this.player.getEntity().getMaxHealth()) {
            this.blindnessEffect.tryActivate();
            this.regenerationEffect.tryActivate();
        }
    }

    @Override
    public void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
    }

    @Override
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
    }

    @Override
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
    }

    @Override
    public void onBeingInLava() {
    }

    @Override
    public void onBeingInWater() {
    }

    @Override
    public void onBeingUnderRain() {
    }

    @Override
    public String getFamilyName() {
        return ((ModArmor)ArmorRegistry.LAPIS_BOOTS.get()).getArmorFamilyName();
    }

    @Override
    public int getPriority() {
        return 5;
    }

    private boolean isFireOrMagmaDamage(DamageSource damageSource) {
        boolean isDamagedByInFire = damageSource.is(DamageTypes.IN_FIRE);
        boolean isDamagedByOnFire = damageSource.is(DamageTypes.ON_FIRE);
        boolean isDamagedByMagma = damageSource.is(DamageTypes.HOT_FLOOR);
        return isDamagedByInFire || isDamagedByOnFire || isDamagedByMagma;
    }
}

