/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.effect;

import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.effect.ArmorEffect;
import com.pekar.angelblock.events.effect.IExtendedSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingArmorEffect;
import com.pekar.angelblock.events.effect.State;
import com.pekar.angelblock.events.player.IModMobEffectInstance;
import com.pekar.angelblock.events.player.IPlayer;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;

class SwitchingArmorEffect
extends ArmorEffect<ISwitchingArmorEffect>
implements IExtendedSwitchingArmorEffect {
    protected SwitchingArmorEffect(IPlayer player, IArmor armor, Holder<MobEffect> effectType, int defaultAmplifier) {
        super(player, armor, effectType, defaultAmplifier);
    }

    @Override
    protected IModMobEffectInstance setEffect(int amplifier, int duration) {
        return this.player.setEffect((Holder<MobEffect>)this.effectType, amplifier, this.getShowIcon());
    }

    @Override
    public final boolean isOn() {
        return this.getState().isOn();
    }

    @Override
    public final void trySwitch() {
        this.trySwitch(this.defaultAmplifier);
    }

    @Override
    public void trySwitch(int amplifier) {
        State invertedState = this.getState().isOn() ? State.OFF : State.ON;
        this.trySwitchTo(this.isAvailable() && invertedState.isOn(), amplifier);
    }

    @Override
    public void trySwitchOn(int amplifier) {
        if (this.isAnotherActive()) {
            if (this.isInfinite()) {
                this.updateActivity(amplifier);
            }
            return;
        }
        this.tryActivateInternal(amplifier, -1);
    }

    @Override
    public void updateActivity(int amplifier) {
        super.updateActivity(amplifier, -1);
    }

    @Override
    public void trySwitchOff() {
        this.tryRemove();
    }

    @Override
    public final void trySwitchTo(boolean switchOn) {
        this.trySwitchTo(switchOn, this.defaultAmplifier);
    }

    protected final void trySwitchTo(boolean switchOn, int amplifier) {
        if (switchOn) {
            this.trySwitchOn(amplifier);
        } else {
            this.trySwitchOff();
        }
    }

    @Override
    public final void trySwitchOn() {
        this.trySwitchOn(this.defaultAmplifier);
    }

    @Override
    public ISwitchingArmorEffect getSelf() {
        return this;
    }

    @Override
    public void setSwitchState(boolean isOn) {
        super.setSwitchState(isOn);
    }
}

